/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner;

import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.managers.ElkObjectEntityRecyclingFactory;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.elk.reasoner.ReasonerInterrupter;
import org.semanticweb.elk.reasoner.config.ReasonerConfiguration;
import org.semanticweb.elk.reasoner.stages.LoggingStageExecutor;
import org.semanticweb.elk.reasoner.stages.ReasonerStageExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReasonerFactory {
    static final Logger LOGGER_ = LoggerFactory.getLogger(ReasonerFactory.class);
    static final ReasonerStageExecutor DEFAULT_STAGE_EXECUTOR = new LoggingStageExecutor();
    static final ReasonerInterrupter DEFAULT_INTERRUPTER = new ReasonerInterrupter();

    public Reasoner createReasoner(AxiomLoader.Factory axiomLoaderFactory) {
        return this.createReasoner(axiomLoaderFactory, ReasonerConfiguration.getConfiguration());
    }

    public Reasoner createReasoner(AxiomLoader.Factory axiomLoaderFactory, ReasonerConfiguration config) {
        return this.createReasoner(axiomLoaderFactory, DEFAULT_INTERRUPTER, DEFAULT_STAGE_EXECUTOR, config);
    }

    Reasoner createReasoner(AxiomLoader.Factory axiomLoaderFactory, ReasonerInterrupter interrupter, ReasonerStageExecutor stageExecutor, ReasonerConfiguration config) {
        return this.createReasoner((ElkObject.Factory)new ElkObjectEntityRecyclingFactory(), axiomLoaderFactory, interrupter, stageExecutor, config);
    }

    Reasoner createReasoner(ElkObject.Factory elkFactory, AxiomLoader.Factory axiomLoaderFactory, ReasonerInterrupter interrupter, ReasonerStageExecutor stageExecutor, ReasonerConfiguration config) {
        Reasoner reasoner = ReasonerFactory.createReasoner(elkFactory, interrupter, stageExecutor, config);
        reasoner.registerAxiomLoader(axiomLoaderFactory);
        return reasoner;
    }

    public Reasoner createReasoner(Reasoner reasoner, ElkObject.Factory elkFactory, ReasonerConfiguration config) {
        return ReasonerFactory.createReasoner(elkFactory, reasoner.getInterrupter(), reasoner.getStageExecutor(), config);
    }

    public Reasoner createReasoner(ReasonerConfiguration config) {
        return ReasonerFactory.createReasoner(DEFAULT_INTERRUPTER, DEFAULT_STAGE_EXECUTOR, config);
    }

    static Reasoner createReasoner(ReasonerInterrupter interrupter, ReasonerStageExecutor stageExecutor, ReasonerConfiguration config) {
        return ReasonerFactory.createReasoner((ElkObject.Factory)new ElkObjectEntityRecyclingFactory(), interrupter, stageExecutor, config);
    }

    static Reasoner createReasoner(ElkObject.Factory elkFactory, ReasonerInterrupter interrupter, ReasonerStageExecutor stageExecutor, ReasonerConfiguration config) {
        return new Reasoner(elkFactory, interrupter, stageExecutor, config);
    }
}

