/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.completeness;

import org.semanticweb.elk.reasoner.completeness.Feature;
import org.semanticweb.elk.reasoner.completeness.OccurrenceManager;
import org.slf4j.Logger;

public class CombinedOccurrenceManager
implements OccurrenceManager {
    OccurrenceManager[] managers_;

    public CombinedOccurrenceManager(OccurrenceManager ... managers) {
        this.managers_ = managers;
    }

    @Override
    public int getOccurrenceCount(Feature occurrence) {
        int sum = 0;
        for (OccurrenceManager manager : this.managers_) {
            sum += manager.getOccurrenceCount(occurrence);
        }
        return sum;
    }

    @Override
    public void logOccurrences(Feature occurrence, Logger logger) {
        for (OccurrenceManager manager : this.managers_) {
            manager.logOccurrences(occurrence, logger);
        }
    }

    @Override
    public boolean hasNewOccurrencesOf(Feature occurrence) {
        for (OccurrenceManager manager : this.managers_) {
            if (!manager.hasNewOccurrencesOf(occurrence)) continue;
            return true;
        }
        return false;
    }
}

