/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.completeness;

import java.util.ArrayList;
import org.semanticweb.elk.reasoner.completeness.CombinedOccurrenceManager;
import org.semanticweb.elk.reasoner.completeness.Incompleteness;
import org.semanticweb.elk.reasoner.completeness.IncompletenessMonitor;
import org.semanticweb.elk.reasoner.completeness.IncompletenessStatusMonitor;
import org.semanticweb.elk.reasoner.completeness.ObjectPropertyTaxonomyIncompleteness;
import org.semanticweb.elk.reasoner.completeness.OccurrenceManager;
import org.semanticweb.elk.reasoner.completeness.TopIncompletenessMonitor;
import org.semanticweb.elk.reasoner.completeness.UnsupportedQueryTypeIncompletenessMonitor;

public class IncompletenessManager {
    private final OccurrenceManager occurrencesInOntology_;
    private final IncompletenessMonitor ontologySatisfiabilityMonitor_;
    private final IncompletenessMonitor classTaxonomyMonitor_;
    private final IncompletenessMonitor objectPropertyTaxonomyMonitor_;
    private final IncompletenessMonitor instanceTaxonomyMonitor_;
    private final IncompletenessMonitor generalQueryMonitor_;

    public IncompletenessManager(OccurrenceManager occurrencesInOntology) {
        this.occurrencesInOntology_ = occurrencesInOntology;
        this.ontologySatisfiabilityMonitor_ = new IncompletenessStatusMonitor(new TopIncompletenessMonitor(occurrencesInOntology), "Ontology satisfiability cannot be checked! Enable INFO for details.");
        this.objectPropertyTaxonomyMonitor_ = Incompleteness.firstOf(new IncompletenessStatusMonitor(this.ontologySatisfiabilityMonitor_, "Object property inclusions may be incomplete because ontology satisfiability cannot be checked!"), new IncompletenessStatusMonitor(Incompleteness.firstOf(ObjectPropertyTaxonomyIncompleteness.appendMonitorsTo(new ArrayList<IncompletenessMonitor>(), occurrencesInOntology)), "Object property inclusions may be incomplete! Enable INFO for details."));
        this.classTaxonomyMonitor_ = new IncompletenessStatusMonitor(this.ontologySatisfiabilityMonitor_, "Class inclusions may be incomplete because ontology satisfiability cannot be checked!");
        this.instanceTaxonomyMonitor_ = new IncompletenessStatusMonitor(this.ontologySatisfiabilityMonitor_, "Instance relations may be incomplete because ontology satisfiability cannot be checked!");
        this.generalQueryMonitor_ = new IncompletenessStatusMonitor(this.ontologySatisfiabilityMonitor_, "Query answers may be incomplete because ontology satisfiability cannot be checked!");
    }

    public IncompletenessMonitor getOntologySatisfiabilityMonitor() {
        return this.ontologySatisfiabilityMonitor_;
    }

    public IncompletenessMonitor getClassTaxonomyMonitor() {
        return this.classTaxonomyMonitor_;
    }

    public IncompletenessMonitor getObjectPropertyTaxonomyMonitor() {
        return this.objectPropertyTaxonomyMonitor_;
    }

    public IncompletenessMonitor getInstanceTaxonomyMonitor() {
        return this.instanceTaxonomyMonitor_;
    }

    public IncompletenessMonitor getQueryMonitor(OccurrenceManager occurencesInQuery) {
        return Incompleteness.firstOf(this.generalQueryMonitor_, new IncompletenessStatusMonitor(Incompleteness.firstOf(new UnsupportedQueryTypeIncompletenessMonitor(occurencesInQuery), new TopIncompletenessMonitor(new CombinedOccurrenceManager(this.occurrencesInOntology_, occurencesInQuery))), "Query answers may be incomplete! Enable INFO for details."));
    }
}

