/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.completeness;

import java.util.EnumSet;
import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.reasoner.completeness.Feature;
import org.semanticweb.elk.reasoner.completeness.OccurrenceCounter;
import org.semanticweb.elk.reasoner.completeness.OccurrenceManager;
import org.slf4j.Logger;

public class OccurrencesInClassExpressionQuery
implements OccurrenceManager {
    private final ElkClassExpression query_;
    private final OccurrenceCounter occurrenceCounter_;
    private Set<Feature> reportedOccurrences_ = EnumSet.noneOf(Feature.class);

    public OccurrencesInClassExpressionQuery(ElkClassExpression query, OccurrenceCounter occurrenceCounter) {
        this.query_ = query;
        this.occurrenceCounter_ = occurrenceCounter;
    }

    ElkClassExpression getQuery() {
        return this.query_;
    }

    @Override
    public int getOccurrenceCount(Feature occurrence) {
        return this.occurrenceCounter_.getOccurrenceCount(occurrence);
    }

    @Override
    public void logOccurrences(Feature occurrence, Logger logger) {
        int count = this.getOccurrenceCount(occurrence);
        String occurrences = count == 1 ? "occurrence" : "occurrences";
        logger.info("{} {} of {} found in the queried class expression {}", new Object[]{count, occurrences, occurrence.getConstructor(), this.query_});
        this.reportedOccurrences_.add(occurrence);
    }

    @Override
    public boolean hasNewOccurrencesOf(Feature occurrence) {
        return !this.reportedOccurrences_.contains((Object)occurrence) && this.getOccurrenceCount(occurrence) > 0;
    }
}

