/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.completeness;

import java.util.EnumSet;
import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.reasoner.completeness.Feature;
import org.semanticweb.elk.reasoner.completeness.OccurrenceCounter;
import org.semanticweb.elk.reasoner.completeness.OccurrenceManager;
import org.slf4j.Logger;

public class OccurrencesInEntailmentQuery
implements OccurrenceManager {
    private final ElkAxiom query_;
    private final OccurrenceCounter occurrenceCounter_;
    private Set<Feature> reportedOccurrences_ = EnumSet.noneOf(Feature.class);

    public OccurrencesInEntailmentQuery(ElkAxiom query, OccurrenceCounter occurrenceCounter) {
        this.query_ = query;
        this.occurrenceCounter_ = occurrenceCounter;
    }

    ElkAxiom getQuery() {
        return this.query_;
    }

    @Override
    public int getOccurrenceCount(Feature occurrence) {
        return this.occurrenceCounter_.getOccurrenceCount(occurrence);
    }

    @Override
    public void logOccurrences(Feature occurrence, Logger logger) {
        int count = this.getOccurrenceCount(occurrence);
        String occurrencesString = count == 1 ? "occurrence" : "occurrences";
        String polarityString = "";
        switch (occurrence.getPolarity()) {
            case POSITIVE: {
                polarityString = "negative ";
                break;
            }
            case NEGATIVE: {
                polarityString = "positive ";
            }
        }
        logger.info("{} {}{} of {} found in the entailment query {}", new Object[]{count, polarityString, occurrencesString, occurrence.getConstructor(), this.query_});
    }

    @Override
    public boolean hasNewOccurrencesOf(Feature occurrence) {
        return !this.reportedOccurrences_.contains((Object)occurrence) && this.getOccurrenceCount(occurrence) > 0;
    }
}

