/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.completeness;

import java.util.Collection;
import org.semanticweb.elk.reasoner.completeness.IncompletenessMonitor;
import org.slf4j.Logger;

public class SomeOfIncompletenessMonitor
implements IncompletenessMonitor {
    private static final int DEFAULT_EXPLANATION_LIMIT_ = 5;
    private final int explanationLimit_;
    private final IncompletenessMonitor[] monitors_;
    private int countIncompletenessProblems_ = 0;

    SomeOfIncompletenessMonitor(int explanationLimit, IncompletenessMonitor ... monitors) {
        this.explanationLimit_ = explanationLimit;
        this.monitors_ = monitors;
    }

    SomeOfIncompletenessMonitor(int explanationLimit, Collection<IncompletenessMonitor> monitors) {
        this(explanationLimit, monitors.toArray(new IncompletenessMonitor[0]));
    }

    SomeOfIncompletenessMonitor(IncompletenessMonitor ... monitors) {
        this(5, monitors);
    }

    SomeOfIncompletenessMonitor(Collection<IncompletenessMonitor> monitors) {
        this(5, monitors);
    }

    @Override
    public boolean isIncompletenessDetected() {
        for (IncompletenessMonitor monitor : this.monitors_) {
            if (!monitor.isIncompletenessDetected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStatusChanged(Logger logger) {
        if (!logger.isInfoEnabled()) {
            return false;
        }
        int countIncompletenessProblems = 0;
        for (IncompletenessMonitor monitor : this.monitors_) {
            if (monitor.isIncompletenessDetected() && countIncompletenessProblems++ >= this.explanationLimit_ || !monitor.isStatusChanged(logger)) continue;
            return true;
        }
        return countIncompletenessProblems != this.countIncompletenessProblems_;
    }

    @Override
    public void logStatus(Logger logger) {
        if (!logger.isInfoEnabled()) {
            return;
        }
        int countIncompletenessProblems = 0;
        for (IncompletenessMonitor monitor : this.monitors_) {
            if (monitor.isIncompletenessDetected() && countIncompletenessProblems++ >= this.explanationLimit_) continue;
            monitor.logStatus(logger);
        }
        if (countIncompletenessProblems == this.countIncompletenessProblems_) {
            return;
        }
        this.countIncompletenessProblems_ = countIncompletenessProblems;
        String different = countIncompletenessProblems == 1 ? "" : " different";
        String types = countIncompletenessProblems == 1 ? "type" : "types";
        logger.info("... {}{} incompleteness problem {} detected", new Object[]{countIncompletenessProblems, different, types});
    }
}

