/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.config;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.semanticweb.elk.reasoner.config.ReasonerConfiguration;
import org.semanticweb.elk.util.collections.CapacityBalancingEvictor;
import org.semanticweb.elk.util.collections.CountingEvictor;
import org.semanticweb.elk.util.collections.Evictor;
import org.semanticweb.elk.util.collections.NQEvictor;
import org.semanticweb.elk.util.collections.RecencyEvictor;

public class EvictorBuilder {
    public static final Map<String, Class<?>> EVICTOR_CLASS_SHORTCUT;

    private static void put(ImmutableMap.Builder<String, Class<?>> builder, Class<?> value) {
        builder.put((Object)value.getSimpleName(), value);
    }

    public static Evictor.Builder valueOf(String value) throws IllegalArgumentException {
        Object result;
        Method method;
        int indexOfArgs = value.indexOf("(");
        if (indexOfArgs < 0) {
            throw new IllegalArgumentException("Cannot separate type from arguments! value: " + value);
        }
        String typeName = value.substring(0, indexOfArgs).trim();
        Class<?> clazz = EVICTOR_CLASS_SHORTCUT.get(typeName);
        if (clazz == null) {
            try {
                clazz = Class.forName(typeName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("There is no class for the type! value: " + value, e);
            }
        }
        if (!Evictor.Builder.class.isAssignableFrom(clazz)) {
            Class<?> builderClass = null;
            for (Class<?> innerClass : clazz.getClasses()) {
                if (!Evictor.Builder.class.isAssignableFrom(innerClass)) continue;
                if (builderClass != null) {
                    throw new IllegalArgumentException("The type contains multiple builder classes! value: " + value);
                }
                builderClass = innerClass;
            }
            if (builderClass == null) {
                throw new IllegalArgumentException("The type does not contains builder class! value: " + value);
            }
            clazz = builderClass;
        }
        if ((method = ReasonerConfiguration.getValueOfMethod(clazz)) == null) {
            throw new IllegalArgumentException("The builder class does not have public static method valueOf with a String argument! value: " + value);
        }
        try {
            result = method.invoke(null, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Exception when calling valueOf of the builder class! value: " + value, e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)cause;
            }
            throw new IllegalArgumentException("Exception when calling valueOf of the builder class! value: " + value, e);
        }
        if (!(result instanceof Evictor.Builder)) {
            throw new IllegalArgumentException("The result of calling valueOf of the builder class is not a builder! value: " + value);
        }
        return (Evictor.Builder)result;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        EvictorBuilder.put(builder, RecencyEvictor.class);
        EvictorBuilder.put(builder, CapacityBalancingEvictor.class);
        EvictorBuilder.put(builder, CountingEvictor.class);
        EvictorBuilder.put(builder, NQEvictor.class);
        EVICTOR_CLASS_SHORTCUT = builder.build();
    }
}

