/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.entailments;

import java.util.Collection;
import java.util.Collections;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.reasoner.entailments.DefaultEntailmentVisitor;
import org.semanticweb.elk.reasoner.entailments.impl.OntologyInconsistencyEntailsAnyAxiomImpl;
import org.semanticweb.elk.reasoner.entailments.impl.OntologyInconsistencyImpl;
import org.semanticweb.elk.reasoner.entailments.model.AxiomEntailment;
import org.semanticweb.elk.reasoner.entailments.model.Entailment;
import org.semanticweb.elk.reasoner.entailments.model.EntailmentInference;
import org.semanticweb.elk.reasoner.proof.ReasonerProof;

public class InconsistencyProofWrapper
implements ReasonerProof<EntailmentInference> {
    private final ReasonerProof<? extends EntailmentInference> inconsistencyEvidence_;
    private final Entailment.Visitor<Collection<? extends EntailmentInference>> GET_INFERENCES = new DefaultEntailmentVisitor<Collection<? extends EntailmentInference>>(){

        @Override
        public Collection<? extends EntailmentInference> defaultVisit(Entailment entailment) {
            return InconsistencyProofWrapper.this.inconsistencyEvidence_.getInferences(entailment);
        }

        @Override
        public <A extends ElkAxiom> Collection<? extends EntailmentInference> defaultAxiomEntailmentVisit(AxiomEntailment<A> axiomEntailment) {
            return Collections.singleton(new OntologyInconsistencyEntailsAnyAxiomImpl(axiomEntailment));
        }
    };

    public InconsistencyProofWrapper(ReasonerProof<? extends EntailmentInference> inconsistencyEvidence) {
        this.inconsistencyEvidence_ = inconsistencyEvidence;
    }

    @Override
    public Collection<? extends EntailmentInference> getInferences(Object conclusion) {
        Collection<? extends EntailmentInference> infs = this.inconsistencyEvidence_.getInferences(OntologyInconsistencyImpl.INSTANCE);
        if (infs == null || infs.isEmpty()) {
            return Collections.emptyList();
        }
        if (conclusion instanceof Entailment) {
            return ((Entailment)conclusion).accept(this.GET_INFERENCES);
        }
        return Collections.emptyList();
    }
}

