/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.incremental;

import org.semanticweb.elk.util.logging.LogLevel;
import org.semanticweb.elk.util.logging.LoggerWrap;
import org.semanticweb.elk.util.logging.statistics.AbstractStatistics;
import org.slf4j.Logger;

public class IncrementalProcessingStatistics
extends AbstractStatistics {
    long changeInitContextProcessingTime;
    long changeInitContextCollectionProcessingTime;
    long countContexts;
    long countContextSubsumers;

    public long getContextCount() {
        return this.countContexts;
    }

    public long getSubsumersPerContextCount() {
        if (!this.measurementsTaken()) {
            return 0L;
        }
        return this.countContextSubsumers / (long)this.getNumberOfMeasurements();
    }

    public long getChangeInitContextProcessingTime() {
        if (!this.measurementsTaken()) {
            return 0L;
        }
        return this.changeInitContextProcessingTime / (long)this.getNumberOfMeasurements();
    }

    public long getChangeInitContextCollectionProcessingTime() {
        if (!this.measurementsTaken()) {
            return 0L;
        }
        return this.changeInitContextCollectionProcessingTime / (long)this.getNumberOfMeasurements();
    }

    public void reset() {
        super.reset();
        this.changeInitContextProcessingTime = 0L;
        this.changeInitContextCollectionProcessingTime = 0L;
        this.countContexts = 0L;
        this.countContextSubsumers = 0L;
    }

    public synchronized void add(IncrementalProcessingStatistics stats) {
        super.add((AbstractStatistics)stats);
        this.changeInitContextProcessingTime += stats.changeInitContextProcessingTime;
        this.changeInitContextCollectionProcessingTime += stats.changeInitContextCollectionProcessingTime;
        this.countContexts += stats.countContexts;
        this.countContextSubsumers += stats.countContextSubsumers;
    }

    public void print(Logger logger, LogLevel level) {
        if (!LoggerWrap.isEnabledFor((Logger)logger, (LogLevel)level) || !this.measurementsTaken()) {
            return;
        }
        if (this.changeInitContextProcessingTime > 0L) {
            LoggerWrap.log((Logger)logger, (LogLevel)level, (String)("Total context processing time during change initialization: " + this.changeInitContextProcessingTime / (long)this.getNumberOfMeasurements()));
        }
    }
}

