/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.classes;

import org.semanticweb.elk.RevertibleAction;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkUnexpectedIndexingException;
import org.semanticweb.elk.reasoner.indexing.model.HasOccurrence;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.model.OccurrenceIncrement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

interface HasOccurrenceDefaults
extends HasOccurrence {
    public static final Logger LOGGER_ = LoggerFactory.getLogger(HasOccurrenceDefaults.class);

    public int getTotalOccurrenceNumber();

    public void updateTotalOccurrenceNumber(int var1);

    @Override
    default public boolean occurs() {
        return this.getTotalOccurrenceNumber() > 0;
    }

    @Override
    default public String printOccurrenceNumbers() {
        return "all=" + this.getTotalOccurrenceNumber();
    }

    default public void checkOccurrenceNumbers() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace(this.toString() + " occurences: " + this.printOccurrenceNumbers());
        }
        if (this.getTotalOccurrenceNumber() < 0) {
            throw new ElkUnexpectedIndexingException(this.toString() + " has a negative total occurrence: " + this.printOccurrenceNumbers());
        }
    }

    default public RevertibleAction getIndexingAction(ModifiableOntologyIndex index, OccurrenceIncrement increment) {
        return RevertibleAction.create(() -> {
            this.updateTotalOccurrenceNumber(increment.totalIncrement);
            this.checkOccurrenceNumbers();
            return true;
        }, () -> this.updateTotalOccurrenceNumber(-increment.totalIncrement));
    }
}

