/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.classes;

import org.semanticweb.elk.RevertibleAction;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.reasoner.indexing.classes.StructuralIndexedClassEntryImpl;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkUnexpectedIndexingException;
import org.semanticweb.elk.reasoner.indexing.model.HasNegativeOccurrence;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassEntity;
import org.semanticweb.elk.reasoner.indexing.model.IndexedPredefinedClass;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedClass;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.model.OccurrenceIncrement;
import org.semanticweb.elk.reasoner.saturation.rules.contextinit.OwlThingContextInitRule;

final class ModifiableIndexedOwlThingImpl
extends StructuralIndexedClassEntryImpl
implements ModifiableIndexedClass,
IndexedPredefinedClass,
HasNegativeOccurrence {
    private int negativeOccurrenceNo_ = 0;

    ModifiableIndexedOwlThingImpl(ElkClass owlThing) {
        super(owlThing);
    }

    @Override
    public boolean occursNegatively() {
        return this.negativeOccurrenceNo_ > 0;
    }

    @Override
    public String printOccurrenceNumbers() {
        return super.printOccurrenceNumbers() + "; neg=" + this.negativeOccurrenceNo_;
    }

    @Override
    public void checkOccurrenceNumbers() {
        super.checkOccurrenceNumbers();
        if (this.negativeOccurrenceNo_ < 0) {
            throw new ElkUnexpectedIndexingException(this.toString() + " has a negative occurrence: " + this.printOccurrenceNumbers());
        }
    }

    @Override
    public RevertibleAction getIndexingAction(ModifiableOntologyIndex index, OccurrenceIncrement increment) {
        return RevertibleAction.create(() -> !this.occursNegatively() && increment.negativeIncrement > 0, () -> OwlThingContextInitRule.addRuleFor(this, index), () -> OwlThingContextInitRule.removeRuleFor(this, index)).then(RevertibleAction.create(() -> {
            this.negativeOccurrenceNo_ += increment.negativeIncrement;
            return true;
        }, () -> this.negativeOccurrenceNo_ -= increment.negativeIncrement)).then(super.getIndexingAction(index, increment)).then(RevertibleAction.create(() -> !this.occursNegatively() && increment.negativeIncrement < 0, () -> OwlThingContextInitRule.removeRuleFor(this, index), () -> OwlThingContextInitRule.addRuleFor(this, index)));
    }

    @Override
    public <O> O accept(IndexedClassEntity.Visitor<O> visitor) {
        return visitor.visit(this);
    }
}

