/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.classes;

import org.semanticweb.elk.RevertibleAction;
import org.semanticweb.elk.reasoner.indexing.classes.ModifiableIndexedClassExpressionImpl;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkUnexpectedIndexingException;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.model.OccurrenceIncrement;
import org.semanticweb.elk.reasoner.indexing.model.StructuralIndexedComplexClassExpressionEntry;

abstract class StructuralIndexedComplexClassExpressionEntryImpl<T extends StructuralIndexedComplexClassExpressionEntryImpl<T>>
extends ModifiableIndexedClassExpressionImpl<T, StructuralIndexedComplexClassExpressionEntry<?>>
implements StructuralIndexedComplexClassExpressionEntry<T> {
    private int negativeOccurrenceNo_ = 0;
    private int positiveOccurrenceNo_ = 0;

    StructuralIndexedComplexClassExpressionEntryImpl(int structuralHash) {
        super(structuralHash);
    }

    @Override
    public boolean occursNegatively() {
        return this.negativeOccurrenceNo_ > 0;
    }

    @Override
    public boolean occursPositively() {
        return this.positiveOccurrenceNo_ > 0;
    }

    @Override
    public boolean occurs() {
        return this.occursNegatively() || this.occursPositively();
    }

    @Override
    public String printOccurrenceNumbers() {
        return "neg=" + this.negativeOccurrenceNo_ + "; pos=" + this.positiveOccurrenceNo_;
    }

    void checkOccurrenceNumbers() {
        if (this.negativeOccurrenceNo_ < 0) {
            throw new ElkUnexpectedIndexingException(this.toString() + " has a negative occurrence: " + this.printOccurrenceNumbers());
        }
        if (this.positiveOccurrenceNo_ < 0) {
            throw new ElkUnexpectedIndexingException(this.toString() + " has a negative occurrence: " + this.printOccurrenceNumbers());
        }
    }

    @Override
    public RevertibleAction getIndexingAction(ModifiableOntologyIndex index, OccurrenceIncrement increment) {
        return RevertibleAction.create(() -> {
            this.negativeOccurrenceNo_ += increment.negativeIncrement;
            this.positiveOccurrenceNo_ += increment.positiveIncrement;
            return true;
        }, () -> {
            this.negativeOccurrenceNo_ -= increment.negativeIncrement;
            this.positiveOccurrenceNo_ -= increment.positiveIncrement;
        });
    }

    @Override
    public final <O> O accept(IndexedClassExpression.Visitor<O> visitor) {
        return (O)this.accept(visitor);
    }
}

