/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.classes;

import org.semanticweb.elk.reasoner.indexing.classes.ModifiableIndexedObjectBaseFactory;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkIndexingException;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedAxiom;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.model.OccurrenceIncrement;
import org.semanticweb.elk.reasoner.indexing.model.StructuralIndexedSubObject;

public class UpdatingModifiableIndexedObjectFactory
extends ModifiableIndexedObjectBaseFactory {
    private final ModifiableOntologyIndex index_;
    private final OccurrenceIncrement increment_;

    public UpdatingModifiableIndexedObjectFactory(ModifiableOntologyIndex index, OccurrenceIncrement increment) {
        this.index_ = index;
        this.increment_ = increment;
    }

    @Override
    protected <T extends StructuralIndexedSubObject<T>> T filter(T input) {
        T result = this.index_.resolve(input);
        if (result == null) {
            result = input;
        }
        if (!result.occurs()) {
            this.index_.add(result);
        }
        if (!result.getIndexingAction(this.index_, this.increment_).apply()) {
            throw new ElkIndexingException(result.toString() + ": cannot update in Index for " + this.increment_ + " occurrences!");
        }
        if (!result.occurs()) {
            this.index_.remove(result);
        }
        return result;
    }

    @Override
    protected <T extends ModifiableIndexedAxiom> T filter(T input) {
        int i;
        if (this.increment_.totalIncrement > 0) {
            for (i = 0; i < this.increment_.totalIncrement; ++i) {
                if (input.addOccurrence(this.index_)) continue;
                throw new ElkIndexingException(input.toString() + ": cannot be added to Index!");
            }
        }
        if (this.increment_.totalIncrement < 0) {
            for (i = 0; i < -this.increment_.totalIncrement; ++i) {
                if (input.removeOccurrence(this.index_)) continue;
                throw new ElkIndexingException(input.toString() + ": cannot be removed from Index!");
            }
        }
        return input;
    }
}

