/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.model;

import java.util.List;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.IndexedComplexClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.IndexedComplexPropertyChain;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.model.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.model.IndexedRangeFiller;
import org.semanticweb.elk.reasoner.saturation.context.ContextPremises;
import org.semanticweb.elk.reasoner.saturation.inferences.BackwardLinkComposition;
import org.semanticweb.elk.reasoner.saturation.inferences.BackwardLinkOfObjectSomeValuesFrom;
import org.semanticweb.elk.reasoner.saturation.inferences.ForwardLinkComposition;
import org.semanticweb.elk.reasoner.saturation.inferences.ForwardLinkOfObjectSomeValuesFrom;
import org.semanticweb.elk.reasoner.saturation.properties.SaturatedPropertyChain;
import org.semanticweb.elk.reasoner.saturation.rules.ClassInferenceProducer;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.PropagationFromExistentialFillerRule;

public interface IndexedObjectSomeValuesFrom
extends IndexedComplexClassExpression {
    public IndexedObjectProperty getProperty();

    public IndexedClassExpression getFiller();

    public IndexedRangeFiller getRangeFiller();

    public static class Helper {
        public static void generatePropagations(IndexedObjectProperty property, ContextPremises premises, ClassInferenceProducer producer) {
            for (IndexedClassExpression ice : premises.getComposedSubsumers()) {
                PropagationFromExistentialFillerRule.applyForProperty(ice.getCompositionRuleHead(), property, premises, producer);
            }
        }

        public static IndexedContextRoot getTarget(IndexedObjectSomeValuesFrom existential) {
            SaturatedPropertyChain propertySaturation = existential.getProperty().getSaturated();
            if (propertySaturation.getRanges().isEmpty()) {
                return existential.getFiller();
            }
            return existential.getRangeFiller();
        }

        public static void produceDecomposedExistentialLink(ClassInferenceProducer producer, IndexedContextRoot root, IndexedObjectSomeValuesFrom subsumer) {
            producer.produce(new BackwardLinkOfObjectSomeValuesFrom(root, subsumer));
            if (!subsumer.getProperty().getSaturated().getNonRedundantCompositionsByLeftSubProperty().isEmpty()) {
                producer.produce(new ForwardLinkOfObjectSomeValuesFrom(root, subsumer));
            }
        }

        public static void produceComposedLink(ClassInferenceProducer producer, IndexedContextRoot source, IndexedObjectProperty backwardRelation, IndexedContextRoot inferenceRoot, IndexedPropertyChain forwardRelation, IndexedContextRoot target, IndexedComplexPropertyChain composition) {
            if (composition.getSaturated().getNonRedundantCompositionsByLeftSubProperty().isEmpty() && composition.getSaturated().getRedundantCompositionsByLeftSubProperty().isEmpty()) {
                List<IndexedObjectProperty> toldSuperProperties = composition.getToldSuperProperties();
                List<ElkAxiom> toldSuperPropertiesReasons = composition.getToldSuperPropertiesReasons();
                for (int i = 0; i < toldSuperProperties.size(); ++i) {
                    producer.produce(new BackwardLinkComposition(source, backwardRelation, inferenceRoot, forwardRelation, target, composition, toldSuperProperties.get(i), toldSuperPropertiesReasons.get(i)));
                }
            } else {
                producer.produce(new ForwardLinkComposition(source, backwardRelation, inferenceRoot, forwardRelation, target, composition));
            }
        }
    }

    public static interface Visitor<O> {
        public O visit(IndexedObjectSomeValuesFrom var1);
    }
}

