/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.semanticweb.elk.reasoner.entailments.model.Entailment;
import org.semanticweb.elk.reasoner.entailments.model.EntailmentInference;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.proof.ReasonerProof;
import org.semanticweb.elk.reasoner.query.AbstractIndexedEntailmentQuery;
import org.semanticweb.elk.reasoner.query.ElkQueryException;
import org.semanticweb.elk.reasoner.query.IndexedEntailmentQuery;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SaturationConclusion;

public abstract class AbstractEntailmentQueryWithPremises<E extends Entailment, P extends IndexedEntailmentQuery<? extends Entailment>>
extends AbstractIndexedEntailmentQuery<E> {
    private final List<P> premises_;

    public AbstractEntailmentQueryWithPremises(E query, List<P> premises) {
        super(query);
        this.premises_ = premises;
    }

    public List<P> getPremises() {
        return this.premises_;
    }

    @Override
    public Collection<? extends IndexedContextRoot> getPositivelyIndexed() {
        ArrayList<IndexedContextRoot> result = new ArrayList<IndexedContextRoot>(this.premises_.size());
        for (IndexedEntailmentQuery subsumption : this.premises_) {
            result.addAll(subsumption.getPositivelyIndexed());
        }
        return result;
    }

    @Override
    public ReasonerProof<EntailmentInference> getEvidence(boolean atMostOne, SaturationState<?> saturationState, SaturationConclusion.Factory conclusionFactory) throws ElkQueryException {
        ArrayList<ReasonerProof<EntailmentInference>> proofs = new ArrayList<ReasonerProof<EntailmentInference>>();
        for (IndexedEntailmentQuery premise : this.premises_) {
            ReasonerProof<EntailmentInference> premiseProof = premise.getEvidence(atMostOne, saturationState, conclusionFactory);
            if (premiseProof.getInferences(premise.getQuery()).isEmpty()) {
                return ReasonerProof.empty();
            }
            proofs.add(premiseProof);
        }
        proofs.add(new ReasonerProof<EntailmentInference>(){

            @Override
            public Collection<? extends EntailmentInference> getInferences(Object conclusion) {
                if (!AbstractEntailmentQueryWithPremises.this.getQuery().equals(conclusion)) {
                    return Collections.emptyList();
                }
                return AbstractEntailmentQueryWithPremises.this.getEntailmentInference();
            }
        });
        return ReasonerProof.union(proofs);
    }

    public abstract Collection<? extends EntailmentInference> getEntailmentInference();
}

