/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.query;

import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.printers.OwlFunctionalStylePrinter;
import org.semanticweb.elk.owl.visitors.DummyElkAxiomVisitor;
import org.semanticweb.elk.owl.visitors.ElkAxiomVisitor;
import org.semanticweb.elk.reasoner.completeness.OccurrenceListener;
import org.semanticweb.elk.reasoner.entailments.model.Entailment;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkIndexingUnsupportedFeature;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.query.EntailmentQueryConverter;
import org.semanticweb.elk.reasoner.query.IndexedEntailmentQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntailmentQueryIndexingProcessor
extends DummyElkAxiomVisitor<IndexedEntailmentQuery<? extends Entailment>> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(EntailmentQueryIndexingProcessor.class);
    private final int increment_;
    private final EntailmentQueryConverter converter_;
    private final OccurrenceListener occurrenceTracker_;

    public EntailmentQueryIndexingProcessor(ElkObject.Factory elkFactory, ModifiableOntologyIndex index, int increment, OccurrenceListener indexingListener) {
        this.increment_ = increment;
        this.converter_ = new EntailmentQueryConverter(elkFactory, index, increment);
        this.occurrenceTracker_ = indexingListener;
    }

    protected IndexedEntailmentQuery<? extends Entailment> defaultVisit(ElkAxiom axiom) {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace("$$ indexing {} for {}", (Object)OwlFunctionalStylePrinter.toString((ElkObject)axiom), (Object)(this.increment_ > 0 ? "addition" : "removal"));
        }
        try {
            return (IndexedEntailmentQuery)axiom.accept((ElkAxiomVisitor)this.converter_);
        }
        catch (ElkIndexingUnsupportedFeature e) {
            this.occurrenceTracker_.occurrenceChanged(e.getFeature(), this.increment_);
            return null;
        }
    }
}

