/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.indexing.model.OntologyIndex;
import org.semanticweb.elk.reasoner.saturation.ContextCreatingSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.ContextCreationListener;
import org.semanticweb.elk.reasoner.saturation.ContextFactory;
import org.semanticweb.elk.reasoner.saturation.ContextModificationListener;
import org.semanticweb.elk.reasoner.saturation.ExtendedContext;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.conclusions.classes.DummyClassConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.conclusions.classes.SaturationClassConclusionChecker;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ClassConclusion;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ContextInitialization;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.inferences.ClassInference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSaturationState<EC extends ExtendedContext>
implements SaturationState<EC> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(AbstractSaturationState.class);
    final OntologyIndex ontologyIndex;
    private final Queue<Context> activeContexts_ = new ConcurrentLinkedQueue<Context>();
    private final Queue<EC> notSaturatedContexts_ = new ConcurrentLinkedQueue<EC>();
    private final AtomicInteger contextSetNonSaturatedUpper_ = new AtomicInteger(0);
    private final AtomicInteger contextSetNonSaturatedLower_ = new AtomicInteger(0);
    private final AtomicInteger contextSetSaturatedUpper_ = new AtomicInteger(0);
    private final AtomicInteger contextSetSaturatedLower_ = new AtomicInteger(0);
    private final ContextFactory<EC> contextFactory;
    private final List<SaturationState.ChangeListener<? super EC>> listeners_ = new ArrayList<SaturationState.ChangeListener<? super EC>>();

    public AbstractSaturationState(OntologyIndex index, ContextFactory<EC> factory) {
        this.ontologyIndex = index;
        this.contextFactory = factory;
    }

    @Override
    public OntologyIndex getOntologyIndex() {
        return this.ontologyIndex;
    }

    @Override
    public Collection<EC> getNotSaturatedContexts() {
        return Collections.unmodifiableCollection(new AbstractCollection<EC>(){

            @Override
            public Iterator<EC> iterator() {
                return AbstractSaturationState.this.notSaturatedContexts_.iterator();
            }

            @Override
            public int size() {
                int setSaturatedUpper;
                int setSaturatedLower;
                int nonSaturatedUpper;
                int nonSaturatedLower = AbstractSaturationState.this.contextSetNonSaturatedLower_.get();
                if (nonSaturatedLower != (nonSaturatedUpper = AbstractSaturationState.this.contextSetNonSaturatedUpper_.get())) {
                    LOGGER_.error("Some context are being marked non-saturated!");
                }
                if ((setSaturatedLower = AbstractSaturationState.this.contextSetSaturatedLower_.get()) != (setSaturatedUpper = AbstractSaturationState.this.contextSetSaturatedUpper_.get())) {
                    LOGGER_.error("Some context are being marked saturated!");
                }
                return nonSaturatedLower - setSaturatedUpper;
            }
        });
    }

    @Override
    public int getContextMarkNonSaturatedCount() {
        return this.contextSetNonSaturatedLower_.get();
    }

    @Override
    public int getContextSetSaturatedCount() {
        return this.contextSetSaturatedLower_.get();
    }

    @Override
    public void setContextsSaturated(int saturatedContextLimit) {
        int contextSetSaturatedUpperSnapshot;
        while ((contextSetSaturatedUpperSnapshot = this.contextSetSaturatedUpper_.get()) < saturatedContextLimit) {
            if (contextSetSaturatedUpperSnapshot >= this.contextSetNonSaturatedLower_.get()) {
                int contextSetSaturatedLowerSnapshot = this.contextSetSaturatedLower_.get();
                ExtendedContext next = (ExtendedContext)this.notSaturatedContexts_.peek();
                if (next != null && contextSetSaturatedLowerSnapshot >= this.contextSetNonSaturatedUpper_.get()) {
                    LOGGER_.error("{}: was not marked as saturated", (Object)next);
                }
                return;
            }
            if (!this.contextSetSaturatedUpper_.compareAndSet(contextSetSaturatedUpperSnapshot, contextSetSaturatedUpperSnapshot + 1)) continue;
            ExtendedContext next = (ExtendedContext)this.notSaturatedContexts_.poll();
            if (next.setSaturated(true)) {
                LOGGER_.error("{}: was marked as saturated already", (Object)next);
            }
            this.contextSetSaturatedLower_.incrementAndGet();
            LOGGER_.trace("{}: marked as saturated", (Object)next);
            this.notifyContextMarkedSaturated(next);
        }
        return;
    }

    @Override
    public SaturationStateWriter<EC> getContextModifyingWriter(ContextModificationListener contextModificationListener) {
        return new ContextModifyingWriter(contextModificationListener);
    }

    @Override
    public SaturationStateWriter<EC> getContextModifyingWriter() {
        return this.getContextModifyingWriter(ContextModificationListener.DUMMY);
    }

    @Override
    public ContextCreatingSaturationStateWriter<EC> getContextCreatingWriter(ContextCreationListener contextCreationListener, ContextModificationListener contextModificationListener) {
        return new ContextCreatingWriter(contextCreationListener, contextModificationListener);
    }

    @Override
    public ContextCreatingSaturationStateWriter<EC> getContextCreatingWriter() {
        return this.getContextCreatingWriter(ContextCreationListener.DUMMY, ContextModificationListener.DUMMY);
    }

    @Override
    public boolean addListener(SaturationState.ChangeListener<? super EC> listener) {
        return this.listeners_.add(listener);
    }

    @Override
    public boolean removeListener(SaturationState.ChangeListener<? super EC> listener) {
        return this.listeners_.remove(listener);
    }

    @Override
    public abstract EC getContext(IndexedContextRoot var1);

    void notifyContextsClear() {
        for (int i = 0; i < this.listeners_.size(); ++i) {
            this.listeners_.get(i).contextsClear();
        }
    }

    void notifyContextAddition(EC context) {
        for (int i = 0; i < this.listeners_.size(); ++i) {
            this.listeners_.get(i).contextAddition(context);
        }
    }

    void notifyContextMarkedSaturated(EC context) {
        for (int i = 0; i < this.listeners_.size(); ++i) {
            this.listeners_.get(i).contextMarkedSaturated(context);
        }
    }

    void notifyContextMarkedNonSaturated(EC context) {
        for (int i = 0; i < this.listeners_.size(); ++i) {
            this.listeners_.get(i).contextMarkedNonSaturated(context);
        }
    }

    void notifySaturatedContextModified(EC context) {
        for (int i = 0; i < this.listeners_.size(); ++i) {
            this.listeners_.get(i).saturatedContextModified(context);
        }
    }

    abstract void resetContexts();

    private void reset() {
        this.resetContexts();
        this.activeContexts_.clear();
        this.notSaturatedContexts_.clear();
    }

    abstract EC setIfAbsent(EC var1);

    protected class ContextCreatingWriter
    extends ContextModifyingWriter
    implements ContextCreatingSaturationStateWriter<EC> {
        private final ContextCreationListener contextCreationListener_;

        protected ContextCreatingWriter(ContextCreationListener contextCreationListener, ContextModificationListener contextModificationListener) {
            super(contextModificationListener);
            this.contextCreationListener_ = contextCreationListener;
        }

        protected ContextCreatingWriter() {
            super(ContextModificationListener.DUMMY);
            this.contextCreationListener_ = ContextCreationListener.DUMMY;
        }

        @Override
        public void produce(ClassInference inference) {
            this.produce(this.getCreateContext(inference.getDestination()), inference);
        }

        @Override
        public EC getCreateContext(IndexedContextRoot root) {
            Context previous = AbstractSaturationState.this.getContext(root);
            if (previous != null) {
                return previous;
            }
            Object newContext = AbstractSaturationState.this.contextFactory.createContext(root);
            previous = AbstractSaturationState.this.setIfAbsent(newContext);
            if (previous != null) {
                return previous;
            }
            this.contextCreationListener_.notifyContextCreation((Context)newContext);
            LOGGER_.trace("{}: context created", newContext);
            return newContext;
        }
    }

    class ContextModifyingWriter
    implements SaturationStateWriter<EC> {
        private final ContextModificationListener contextModificationListener_;

        private ContextModifyingWriter(ContextModificationListener contextSaturationListener) {
            this.contextModificationListener_ = contextSaturationListener;
        }

        @Override
        public Context pollForActiveContext() {
            return (Context)AbstractSaturationState.this.activeContexts_.poll();
        }

        void produce(Context context, ClassInference inference) {
            LOGGER_.trace("{}: new inference {}", (Object)context, (Object)inference);
            if (context.addToDo(inference)) {
                LOGGER_.trace("{}: activated", (Object)context);
                AbstractSaturationState.this.activeContexts_.add(context);
            }
        }

        @Override
        public void produce(ClassInference inference) {
            this.produce(AbstractSaturationState.this.getContext(inference.getDestination()), inference);
        }

        void addNotSaturated(EC context) {
            AbstractSaturationState.this.contextSetNonSaturatedUpper_.incrementAndGet();
            LOGGER_.trace("{}: marked as non-saturated", context);
            AbstractSaturationState.this.notSaturatedContexts_.add(context);
            AbstractSaturationState.this.contextSetNonSaturatedLower_.incrementAndGet();
            this.contextModificationListener_.notifyContextModification((Context)context);
            AbstractSaturationState.this.notifyContextMarkedNonSaturated(context);
        }

        boolean markAsNotSaturated(EC context) {
            if (context.setSaturated(false)) {
                this.addNotSaturated(context);
                return true;
            }
            return false;
        }

        boolean markAsNotSaturated(IndexedContextRoot root) {
            Context context = AbstractSaturationState.this.getContext(root);
            return context == null ? false : this.markAsNotSaturated(context);
        }

        @Override
        public void resetContexts() {
            AbstractSaturationState.this.reset();
        }

        @Override
        public SaturationState<EC> getSaturationState() {
            return AbstractSaturationState.this;
        }

        @Override
        public boolean addConclusion(ClassConclusion conclusion) {
            Context context = AbstractSaturationState.this.getContext(conclusion.getDestination());
            return conclusion.accept(new DummyClassConclusionVisitor<Boolean>((ExtendedContext)context){
                final /* synthetic */ ExtendedContext val$context;
                {
                    this.val$context = extendedContext;
                }

                @Override
                protected Boolean defaultVisit(ClassConclusion c) {
                    return ContextModifyingWriter.this.addConclusion(this.val$context, c);
                }

                @Override
                public Boolean visit(ContextInitialization c) {
                    if (this.val$context.containsConclusion(c)) {
                        return false;
                    }
                    ContextModifyingWriter.this.markAsNotSaturated(this.val$context);
                    return ContextModifyingWriter.this.addConclusion(this.val$context, c);
                }
            });
        }

        boolean addConclusion(EC context, ClassConclusion conclusion) {
            if (!context.addConclusion(conclusion)) {
                LOGGER_.trace("{}: inserting {}: already present", context, (Object)conclusion);
                return false;
            }
            LOGGER_.trace("{}: inserting {}: success", context, (Object)conclusion);
            this.checkSaturationFor(conclusion);
            return true;
        }

        @Override
        public boolean removeConclusion(ClassConclusion conclusion) {
            Context context = AbstractSaturationState.this.getContext(conclusion.getDestination());
            if (!context.removeConclusion(conclusion)) {
                LOGGER_.trace("{}: deleting {}: already absent", (Object)context, (Object)conclusion);
                return false;
            }
            LOGGER_.trace("{}: deleting {}: success", (Object)context, (Object)conclusion);
            this.checkSaturationFor(conclusion);
            return true;
        }

        void checkSaturationFor(ClassConclusion conclusion) {
            Context origin = AbstractSaturationState.this.getContext(conclusion.getTraceRoot());
            if (!origin.isSaturated()) {
                return;
            }
            if (SaturationClassConclusionChecker.check(conclusion)) {
                this.markAsNotSaturated(origin);
            } else {
                AbstractSaturationState.this.notifySaturatedContextModified(origin);
            }
        }
    }
}

