/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.indexing.model.OntologyIndex;
import org.semanticweb.elk.reasoner.saturation.AbstractSaturationState;
import org.semanticweb.elk.reasoner.saturation.ContextFactory;
import org.semanticweb.elk.reasoner.saturation.ExtendedContext;

public class MapSaturationState<EC extends ExtendedContext>
extends AbstractSaturationState<EC> {
    private final ConcurrentHashMap<IndexedContextRoot, EC> contextAssignment_;

    public MapSaturationState(OntologyIndex index, ContextFactory<EC> factory, int expectedSize) {
        super(index, factory);
        this.contextAssignment_ = new ConcurrentHashMap(expectedSize);
    }

    public MapSaturationState(OntologyIndex index, ContextFactory<EC> factory) {
        super(index, factory);
        this.contextAssignment_ = new ConcurrentHashMap(index.getClassExpressions().size());
    }

    @Override
    public Collection<EC> getContexts() {
        return this.contextAssignment_.values();
    }

    @Override
    public EC getContext(IndexedContextRoot root) {
        return (EC)((ExtendedContext)this.contextAssignment_.get(root));
    }

    @Override
    void resetContexts() {
        if (!this.contextAssignment_.isEmpty()) {
            this.contextAssignment_.clear();
            this.notifyContextsClear();
        }
    }

    @Override
    EC setIfAbsent(EC context) {
        ExtendedContext previous = (ExtendedContext)this.contextAssignment_.putIfAbsent(context.getRoot(), context);
        if (previous == null) {
            this.notifyContextAddition(context);
        }
        return (EC)previous;
    }
}

