/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation;

import org.semanticweb.elk.reasoner.incremental.IncrementalProcessingStatistics;
import org.semanticweb.elk.reasoner.saturation.conclusions.classes.ClassConclusionStatistics;
import org.semanticweb.elk.reasoner.saturation.context.ContextStatistics;
import org.semanticweb.elk.reasoner.saturation.rules.RuleStatistics;
import org.semanticweb.elk.util.logging.LogLevel;
import org.slf4j.Logger;

public class SaturationStatistics {
    private final ClassConclusionStatistics conclusionsStatistics_ = new ClassConclusionStatistics();
    private final RuleStatistics ruleStatistics_ = new RuleStatistics();
    private final ContextStatistics contextStatistics_ = new ContextStatistics();
    private final IncrementalProcessingStatistics processingStatistics_ = new IncrementalProcessingStatistics();

    public void startMeasurements() {
        this.conclusionsStatistics_.startMeasurements();
        this.ruleStatistics_.startMeasurements();
        this.conclusionsStatistics_.startMeasurements();
        this.processingStatistics_.startMeasurements();
    }

    public void reset() {
        this.conclusionsStatistics_.reset();
        this.ruleStatistics_.reset();
        this.contextStatistics_.reset();
        this.processingStatistics_.reset();
    }

    public synchronized void add(SaturationStatistics statistics) {
        this.conclusionsStatistics_.add(statistics.conclusionsStatistics_);
        this.ruleStatistics_.add(statistics.ruleStatistics_);
        this.contextStatistics_.add(statistics.contextStatistics_);
        this.processingStatistics_.add(statistics.processingStatistics_);
    }

    public void check(Logger logger) {
        this.contextStatistics_.check(logger);
        this.conclusionsStatistics_.check(logger);
    }

    public void print(Logger logger) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        this.conclusionsStatistics_.print(logger);
        this.ruleStatistics_.print(logger);
        this.contextStatistics_.print(logger, LogLevel.DEBUG);
        this.processingStatistics_.print(logger, LogLevel.DEBUG);
    }

    public RuleStatistics getRuleStatistics() {
        return this.ruleStatistics_;
    }

    public ClassConclusionStatistics getConclusionStatistics() {
        return this.conclusionsStatistics_;
    }

    public ContextStatistics getContextStatistics() {
        return this.contextStatistics_;
    }

    public IncrementalProcessingStatistics getIncrementalProcessingStatistics() {
        return this.processingStatistics_;
    }
}

