/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.conclusions.classes;

import org.semanticweb.elk.Reference;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.saturation.conclusions.classes.DummyClassConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.BackwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ClassConclusion;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ClassInconsistency;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ContextInitialization;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.DisjointSubsumer;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ForwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.Propagation;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubClassInclusionComposed;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubClassInclusionDecomposed;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubContextInitialization;
import org.semanticweb.elk.reasoner.saturation.context.ContextPremises;
import org.semanticweb.elk.reasoner.saturation.rules.ClassInferenceProducer;
import org.semanticweb.elk.reasoner.saturation.rules.RuleVisitor;
import org.semanticweb.elk.reasoner.saturation.rules.backwardlinks.LinkedBackwardLinkRule;
import org.semanticweb.elk.reasoner.saturation.rules.backwardlinks.SubsumerBackwardLinkRule;
import org.semanticweb.elk.reasoner.saturation.rules.contextinit.LinkedContextInitRule;
import org.semanticweb.elk.reasoner.saturation.rules.contradiction.ContradictionPropagationRule;
import org.semanticweb.elk.reasoner.saturation.rules.disjointsubsumer.ContradictionCompositionRule;
import org.semanticweb.elk.reasoner.saturation.rules.forwardlink.BackwardLinkFromForwardLinkRule;
import org.semanticweb.elk.reasoner.saturation.rules.forwardlink.NonReflexiveBackwardLinkCompositionRule;
import org.semanticweb.elk.reasoner.saturation.rules.forwardlink.ReflexiveBackwardLinkCompositionRule;
import org.semanticweb.elk.reasoner.saturation.rules.propagations.SubsumerPropagationRule;
import org.semanticweb.elk.reasoner.saturation.rules.subcontextinit.PropagationInitializationRule;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.LinkedSubsumerRule;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.SubsumerDecompositionVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleApplicationClassConclusionVisitor
extends DummyClassConclusionVisitor<Boolean>
implements Reference<ContextPremises> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(RuleApplicationClassConclusionVisitor.class);
    private static ContradictionCompositionRule CONTRADICTION_COMPOSITION_RULE_ = new ContradictionCompositionRule();
    private final Reference<? extends ContextPremises> premisesRef_;
    private final LinkedContextInitRule contextInitRuleHead_;
    final RuleVisitor<?> ruleAppVisitor;
    final ClassInferenceProducer producer;

    public RuleApplicationClassConclusionVisitor(Reference<? extends ContextPremises> premisesRef, LinkedContextInitRule contextInitRuleHead, RuleVisitor<?> ruleAppVisitor, ClassInferenceProducer producer) {
        this.premisesRef_ = premisesRef;
        this.contextInitRuleHead_ = contextInitRuleHead;
        this.ruleAppVisitor = ruleAppVisitor;
        this.producer = producer;
    }

    @Override
    protected Boolean defaultVisit(ClassConclusion conclusion) {
        throw new RuntimeException("Rules for " + conclusion + " not implemented!");
    }

    public ContextPremises get() {
        return (ContextPremises)this.premisesRef_.get();
    }

    @Override
    public Boolean visit(BackwardLink subConclusion) {
        ContextPremises premises = this.get();
        this.ruleAppVisitor.visit(SubsumerBackwardLinkRule.getInstance(), subConclusion, premises, this.producer);
        for (LinkedBackwardLinkRule backLinkRule = premises.getBackwardLinkRuleHead(); backLinkRule != null; backLinkRule = (LinkedBackwardLinkRule)backLinkRule.next()) {
            backLinkRule.accept(this.ruleAppVisitor, subConclusion, premises, this.producer);
        }
        return true;
    }

    @Override
    public Boolean visit(ContextInitialization conclusion) {
        LOGGER_.trace("applying init rules:");
        for (LinkedContextInitRule rule = this.contextInitRuleHead_; rule != null; rule = (LinkedContextInitRule)rule.next()) {
            LOGGER_.trace("init rule: {}", (Object)rule);
            rule.accept(this.ruleAppVisitor, conclusion, this.get(), this.producer);
        }
        return true;
    }

    @Override
    public Boolean visit(ClassInconsistency conclusion) {
        this.ruleAppVisitor.visit(ContradictionPropagationRule.getInstance(), conclusion, this.get(), this.producer);
        return true;
    }

    @Override
    public Boolean visit(DisjointSubsumer conclusion) {
        this.ruleAppVisitor.visit(CONTRADICTION_COMPOSITION_RULE_, conclusion, this.get(), this.producer);
        return true;
    }

    @Override
    public Boolean visit(ForwardLink conclusion) {
        ContextPremises premises = this.get();
        this.ruleAppVisitor.visit(BackwardLinkFromForwardLinkRule.getInstance(), conclusion, premises, this.producer);
        this.ruleAppVisitor.visit(NonReflexiveBackwardLinkCompositionRule.getRuleFor(conclusion), conclusion, premises, this.producer);
        this.ruleAppVisitor.visit(ReflexiveBackwardLinkCompositionRule.getRuleFor(conclusion), conclusion, premises, this.producer);
        return true;
    }

    @Override
    public Boolean visit(Propagation subConclusion) {
        this.ruleAppVisitor.visit(SubsumerPropagationRule.getInstance(), subConclusion, this.get(), this.producer);
        return true;
    }

    @Override
    public Boolean visit(SubClassInclusionComposed conclusion) {
        IndexedClassExpression subsumer = conclusion.getSubsumer();
        for (LinkedSubsumerRule compositionRule = subsumer.getCompositionRuleHead(); compositionRule != null; compositionRule = (LinkedSubsumerRule)compositionRule.next()) {
            compositionRule.accept(this.ruleAppVisitor, subsumer, this.get(), this.producer);
        }
        return true;
    }

    @Override
    public Boolean visit(SubClassInclusionDecomposed conclusion) {
        IndexedClassExpression subsumer = conclusion.getSubsumer();
        subsumer.accept(new SubsumerDecompositionVisitor(this.ruleAppVisitor, this.get(), this.producer));
        return true;
    }

    @Override
    public Boolean visit(SubContextInitialization subConclusion) {
        ContextPremises premises = this.get();
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace("{}::{} applying sub-concept init rules:", (Object)premises.getRoot(), (Object)subConclusion.getSubDestination());
        }
        PropagationInitializationRule.getInstance().accept((RuleVisitor)this.ruleAppVisitor, subConclusion, premises, this.producer);
        return true;
    }
}

