/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rules.backwardlinks;

import org.semanticweb.elk.reasoner.saturation.conclusions.model.BackwardLink;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.context.ContextPremises;
import org.semanticweb.elk.reasoner.saturation.inferences.ClassInconsistencyPropagated;
import org.semanticweb.elk.reasoner.saturation.rules.ClassInferenceProducer;
import org.semanticweb.elk.reasoner.saturation.rules.backwardlinks.AbstractLinkableBackwardLinkRule;
import org.semanticweb.elk.reasoner.saturation.rules.backwardlinks.LinkableBackwardLinkRule;
import org.semanticweb.elk.reasoner.saturation.rules.backwardlinks.LinkedBackwardLinkRuleVisitor;
import org.semanticweb.elk.util.collections.chains.Matcher;
import org.semanticweb.elk.util.collections.chains.ReferenceFactory;
import org.semanticweb.elk.util.collections.chains.SimpleTypeBasedMatcher;

public class ContradictionOverBackwardLinkRule
extends AbstractLinkableBackwardLinkRule {
    public static final String NAME = "Backward Link Contradiction Propagation";
    static final Matcher<LinkableBackwardLinkRule, ContradictionOverBackwardLinkRule> MATCHER_ = new SimpleTypeBasedMatcher(ContradictionOverBackwardLinkRule.class);
    static final ReferenceFactory<LinkableBackwardLinkRule, ContradictionOverBackwardLinkRule> FACTORY_ = new ReferenceFactory<LinkableBackwardLinkRule, ContradictionOverBackwardLinkRule>(){

        public ContradictionOverBackwardLinkRule create(LinkableBackwardLinkRule tail) {
            return new ContradictionOverBackwardLinkRule(tail);
        }
    };

    private ContradictionOverBackwardLinkRule(LinkableBackwardLinkRule tail) {
        super(tail);
    }

    public static void addTo(Context context) {
        context.getBackwardLinkRuleChain().getCreate(MATCHER_, FACTORY_);
    }

    public static void removeFrom(Context context) {
        context.getBackwardLinkRuleChain().remove(MATCHER_);
    }

    public String toString() {
        return NAME;
    }

    @Override
    public void apply(BackwardLink premise, ContextPremises premises, ClassInferenceProducer producer) {
        producer.produce(new ClassInconsistencyPropagated(premise));
    }

    @Override
    public boolean isTracingRule() {
        return true;
    }

    @Override
    public void accept(LinkedBackwardLinkRuleVisitor<?> visitor, BackwardLink premise, ContextPremises premises, ClassInferenceProducer producer) {
        visitor.visit(this, premise, premises, producer);
    }
}

