/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rules.factories;

import org.semanticweb.elk.ModifiableReference;
import org.semanticweb.elk.Reference;
import org.semanticweb.elk.ReferenceImpl;
import org.semanticweb.elk.reasoner.saturation.ContextCreationListener;
import org.semanticweb.elk.reasoner.saturation.ContextModificationListener;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.SaturationStatistics;
import org.semanticweb.elk.reasoner.saturation.SaturationUtils;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.inferences.ClassInference;
import org.semanticweb.elk.reasoner.saturation.rules.RuleStatistics;
import org.semanticweb.elk.reasoner.saturation.rules.RuleVisitor;
import org.semanticweb.elk.reasoner.saturation.rules.factories.BasicRuleEngine;
import org.semanticweb.elk.reasoner.saturation.rules.factories.RuleApplicationFactory;
import org.semanticweb.elk.reasoner.saturation.rules.factories.RuleApplicationInput;
import org.semanticweb.elk.reasoner.saturation.rules.factories.WorkerLocalTodo;
import org.semanticweb.elk.reasoner.saturation.rules.factories.WorkerLocalTodoImpl;
import org.semanticweb.elk.reasoner.saturation.rules.factories.WorkerLocalizedSaturationStateWriter;
import org.semanticweb.elk.util.concurrent.computation.DelegateInterruptMonitor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRuleApplicationFactory<C extends Context, I extends RuleApplicationInput>
extends DelegateInterruptMonitor
implements RuleApplicationFactory<C, I> {
    protected static final Logger LOGGER_ = LoggerFactory.getLogger(AbstractRuleApplicationFactory.class);
    private final SaturationState<? extends C> saturationState_;
    private final SaturationStatistics aggregatedStats_;

    public AbstractRuleApplicationFactory(InterruptMonitor interrupter, SaturationState<? extends C> saturationState) {
        super(interrupter);
        this.saturationState_ = saturationState;
        this.aggregatedStats_ = new SaturationStatistics();
    }

    protected InputProcessor<I> getEngine(ModifiableReference<Context> activeContext, ClassInference.Visitor<Boolean> inferenceProcessor, SaturationStateWriter<? extends C> saturationStateWriter, WorkerLocalTodo localTodo, SaturationStatistics localStatistics) {
        return new BasicRuleEngine(activeContext, inferenceProcessor, localTodo, this, saturationStateWriter, this.aggregatedStats_, localStatistics);
    }

    SaturationStateWriter<? extends C> getBaseWriter(ContextCreationListener creationListener, ContextModificationListener modificationListener) {
        return this.saturationState_.getContextCreatingWriter(creationListener, modificationListener);
    }

    SaturationStateWriter<? extends C> getFinalWriter(SaturationStateWriter<? extends C> writer) {
        return writer;
    }

    protected abstract ClassInference.Visitor<Boolean> getInferenceProcessor(Reference<Context> var1, RuleVisitor<?> var2, SaturationStateWriter<? extends C> var3, SaturationStatistics var4);

    protected RuleVisitor<?> getRuleVisitor(RuleStatistics statistics) {
        return SaturationUtils.getStatsAwareRuleVisitor(statistics);
    }

    @Override
    public final InputProcessor<I> getEngine(ContextCreationListener creationListener, ContextModificationListener modificationListener) {
        SaturationStatistics localStatistics = new SaturationStatistics();
        localStatistics.startMeasurements();
        creationListener = SaturationUtils.addStatsToContextCreationListener(creationListener, localStatistics.getContextStatistics());
        modificationListener = SaturationUtils.addStatsToContextModificationListener(modificationListener, localStatistics.getContextStatistics());
        SaturationStateWriter<C> writer = this.getBaseWriter(creationListener, modificationListener);
        WorkerLocalTodoImpl localTodo = new WorkerLocalTodoImpl();
        writer = new WorkerLocalizedSaturationStateWriter<C>(writer, localTodo);
        writer = this.getFinalWriter(writer);
        RuleVisitor<?> ruleVisitor = this.getRuleVisitor(localStatistics.getRuleStatistics());
        ReferenceImpl activeContext = new ReferenceImpl();
        return this.getEngine((ModifiableReference<Context>)activeContext, this.getInferenceProcessor((Reference<Context>)activeContext, ruleVisitor, writer, localStatistics), writer, localTodo, localStatistics);
    }

    @Override
    public void dispose() {
    }

    @Override
    public SaturationStatistics getSaturationStatistics() {
        return this.aggregatedStats_;
    }

    @Override
    public final SaturationState<? extends C> getSaturationState() {
        return this.saturationState_;
    }
}

