/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rules.forwardlink;

import java.util.Collection;
import java.util.Map;
import org.semanticweb.elk.reasoner.indexing.model.IndexedComplexPropertyChain;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectSomeValuesFrom;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ForwardLink;
import org.semanticweb.elk.reasoner.saturation.context.ContextPremises;
import org.semanticweb.elk.reasoner.saturation.context.SubContextPremises;
import org.semanticweb.elk.reasoner.saturation.rules.ClassInferenceProducer;
import org.semanticweb.elk.reasoner.saturation.rules.forwardlink.AbstractForwardLinkRule;
import org.semanticweb.elk.reasoner.saturation.rules.forwardlink.ForwardLinkRuleVisitor;
import org.semanticweb.elk.util.collections.LazySetIntersection;
import org.semanticweb.elk.util.collections.Multimap;

public class NonReflexiveBackwardLinkCompositionRule
extends AbstractForwardLinkRule {
    private final ForwardLink forwardLink_;
    public static final String NAME = "ForwardLink Non-Reflexive BackwardLink Composition";

    private NonReflexiveBackwardLinkCompositionRule(ForwardLink forwardLink) {
        this.forwardLink_ = forwardLink;
    }

    public static NonReflexiveBackwardLinkCompositionRule getRuleFor(ForwardLink link) {
        return new NonReflexiveBackwardLinkCompositionRule(link);
    }

    public String toString() {
        return NAME;
    }

    @Override
    private void apply(Multimap<IndexedObjectProperty, IndexedComplexPropertyChain> compsByBackwardRelation, ContextPremises premises, ClassInferenceProducer producer) {
        Map<IndexedObjectProperty, ? extends SubContextPremises> subContextMap = premises.getSubContextPremisesByObjectProperty();
        for (IndexedObjectProperty backwardRelation : new LazySetIntersection(compsByBackwardRelation.keySet(), subContextMap.keySet())) {
            Collection compositions = compsByBackwardRelation.get((Object)backwardRelation);
            SubContextPremises subPremises = subContextMap.get(backwardRelation);
            for (IndexedComplexPropertyChain composition : compositions) {
                for (IndexedContextRoot source : subPremises.getLinkedRoots()) {
                    IndexedObjectSomeValuesFrom.Helper.produceComposedLink(producer, source, backwardRelation, premises.getRoot(), this.forwardLink_.getChain(), this.forwardLink_.getTarget(), composition);
                }
            }
        }
    }

    @Override
    public void apply(ForwardLink premise, ContextPremises premises, ClassInferenceProducer producer) {
        this.apply(this.forwardLink_.getChain().getSaturated().getNonRedundantCompositionsByLeftSubProperty(), premises, producer);
    }

    @Override
    public void applyTracing(ForwardLink premise, ContextPremises premises, ClassInferenceProducer producer) {
        this.apply(this.forwardLink_.getChain().getSaturated().getNonRedundantCompositionsByLeftSubProperty(), premises, producer);
        this.apply(this.forwardLink_.getChain().getSaturated().getRedundantCompositionsByLeftSubProperty(), premises, producer);
    }

    @Override
    public boolean isTracingRule() {
        return false;
    }

    @Override
    public void accept(ForwardLinkRuleVisitor<?> visitor, ForwardLink premise, ContextPremises premises, ClassInferenceProducer producer) {
        visitor.visit(this, premise, premises, producer);
    }
}

