/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rules.subsumers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedEquivalentClassesAxiom;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.saturation.context.ContextPremises;
import org.semanticweb.elk.reasoner.saturation.inferences.SubClassInclusionExpandedFirstEquivalentClass;
import org.semanticweb.elk.reasoner.saturation.rules.ClassInferenceProducer;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.AbstractChainableSubsumerRule;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.ChainableSubsumerRule;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.LinkedSubsumerRuleVisitor;
import org.semanticweb.elk.util.collections.chains.Chain;
import org.semanticweb.elk.util.collections.chains.Matcher;
import org.semanticweb.elk.util.collections.chains.ReferenceFactory;
import org.semanticweb.elk.util.collections.chains.SimpleTypeBasedMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EquivalentClassSecondFromFirstRule
extends AbstractChainableSubsumerRule {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(EquivalentClassSecondFromFirstRule.class);
    public static final String NAME = "EquivalentClasses Second from First";
    private final List<IndexedClassExpression> secondEquivalentMembers_ = new ArrayList<IndexedClassExpression>(1);
    private final List<ElkAxiom> reasons_ = new ArrayList<ElkAxiom>(1);
    private static final Matcher<ChainableSubsumerRule, EquivalentClassSecondFromFirstRule> MATCHER_ = new SimpleTypeBasedMatcher(EquivalentClassSecondFromFirstRule.class);
    private static final ReferenceFactory<ChainableSubsumerRule, EquivalentClassSecondFromFirstRule> FACTORY_ = new ReferenceFactory<ChainableSubsumerRule, EquivalentClassSecondFromFirstRule>(){

        public EquivalentClassSecondFromFirstRule create(ChainableSubsumerRule tail) {
            return new EquivalentClassSecondFromFirstRule(tail);
        }
    };

    EquivalentClassSecondFromFirstRule(ChainableSubsumerRule tail) {
        super(tail);
    }

    EquivalentClassSecondFromFirstRule(IndexedClassExpression ice, ElkAxiom reason) {
        this(null);
        this.secondEquivalentMembers_.add(ice);
        this.reasons_.add(reason);
    }

    public static boolean addRuleFor(ModifiableIndexedEquivalentClassesAxiom axiom, ModifiableOntologyIndex index, ElkAxiom reason) {
        return index.add(axiom.getFirstMember(), new EquivalentClassSecondFromFirstRule(axiom.getSecondMember(), reason));
    }

    public static boolean removeRuleFor(ModifiableIndexedEquivalentClassesAxiom axiom, ModifiableOntologyIndex index, ElkAxiom reason) {
        return index.remove(axiom.getFirstMember(), new EquivalentClassSecondFromFirstRule(axiom.getSecondMember(), reason));
    }

    @Deprecated
    public Collection<IndexedClassExpression> getSecondEquivalentMembers() {
        return this.secondEquivalentMembers_;
    }

    public ElkAxiom getReasonForEquivalentMember(IndexedClassExpression firstMember) {
        for (int i = 0; i < this.secondEquivalentMembers_.size(); ++i) {
            if (firstMember != this.secondEquivalentMembers_.get(i)) continue;
            return this.reasons_.get(i);
        }
        return null;
    }

    public String toString() {
        return NAME;
    }

    @Override
    public void apply(IndexedClassExpression premise, ContextPremises premises, ClassInferenceProducer producer) {
        for (int i = 0; i < this.secondEquivalentMembers_.size(); ++i) {
            producer.produce(new SubClassInclusionExpandedFirstEquivalentClass(premises.getRoot(), premise, this.secondEquivalentMembers_.get(i), this.reasons_.get(i)));
        }
    }

    @Override
    public boolean isTracingRule() {
        return true;
    }

    public boolean addTo(Chain<ChainableSubsumerRule> ruleChain) {
        ElkAxiom reason;
        IndexedClassExpression subsumer;
        int i;
        if (this.isEmpty()) {
            return true;
        }
        EquivalentClassSecondFromFirstRule rule = (EquivalentClassSecondFromFirstRule)ruleChain.getCreate(MATCHER_, FACTORY_);
        boolean success = true;
        int added = 0;
        for (i = 0; i < this.secondEquivalentMembers_.size(); ++i) {
            subsumer = this.secondEquivalentMembers_.get(i);
            reason = this.reasons_.get(i);
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("{}: adding to {} reason: {}", new Object[]{subsumer, NAME, reason});
            }
            if (rule.secondEquivalentMembers_.add(subsumer)) {
                rule.reasons_.add(reason);
                ++added;
                continue;
            }
            success = false;
            break;
        }
        if (success) {
            return true;
        }
        for (i = 0; i < this.secondEquivalentMembers_.size() && added != 0; ++i) {
            --added;
            subsumer = this.secondEquivalentMembers_.get(i);
            reason = this.reasons_.get(i);
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("{}: removing from {} reason: {} [revert]", new Object[]{subsumer, NAME, reason});
            }
            int j = rule.indexOf(subsumer, reason);
            rule.secondEquivalentMembers_.remove(j);
            rule.reasons_.remove(j);
        }
        return false;
    }

    public boolean removeFrom(Chain<ChainableSubsumerRule> ruleChain) {
        ElkAxiom reason;
        IndexedClassExpression subsumer;
        int i;
        if (this.isEmpty()) {
            return true;
        }
        EquivalentClassSecondFromFirstRule rule = (EquivalentClassSecondFromFirstRule)ruleChain.find(MATCHER_);
        if (rule == null) {
            return false;
        }
        boolean success = true;
        int removed = 0;
        for (i = 0; i < this.secondEquivalentMembers_.size(); ++i) {
            int j;
            subsumer = this.secondEquivalentMembers_.get(i);
            reason = this.reasons_.get(i);
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("{}: removing from {} reason: {}", new Object[]{subsumer, NAME, reason});
            }
            if ((j = rule.indexOf(subsumer, reason)) >= 0) {
                rule.secondEquivalentMembers_.remove(j);
                rule.reasons_.remove(j);
                ++removed;
                continue;
            }
            success = false;
            break;
        }
        if (success) {
            if (rule.isEmpty()) {
                ruleChain.remove(MATCHER_);
                LOGGER_.trace("{}: removed ", (Object)NAME);
            }
            return true;
        }
        for (i = 0; i < this.secondEquivalentMembers_.size() && removed != 0; ++i) {
            --removed;
            subsumer = this.secondEquivalentMembers_.get(i);
            reason = this.reasons_.get(i);
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("{}: adding to {} reason: {} [revert]", new Object[]{subsumer, NAME, reason});
            }
            rule.secondEquivalentMembers_.add(subsumer);
            rule.reasons_.add(reason);
        }
        return false;
    }

    private int indexOf(IndexedClassExpression subsumer, ElkAxiom reason) {
        for (int i = 0; i < this.secondEquivalentMembers_.size(); ++i) {
            if (!this.secondEquivalentMembers_.get(i).equals(subsumer) || !this.reasons_.get(i).equals(reason)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void accept(LinkedSubsumerRuleVisitor<?> visitor, IndexedClassExpression premise, ContextPremises premises, ClassInferenceProducer producer) {
        visitor.visit(this, premise, premises, producer);
    }

    protected boolean isEmpty() {
        return this.secondEquivalentMembers_.isEmpty();
    }
}

