/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rules.subsumers;

import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.IndexedDefinedClass;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedClass;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedDefinedClass;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedEquivalentClassesAxiom;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.saturation.context.ContextPremises;
import org.semanticweb.elk.reasoner.saturation.inferences.SubClassInclusionExpandedDefinition;
import org.semanticweb.elk.reasoner.saturation.rules.ClassInferenceProducer;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.AbstractSubsumerDecompositionRule;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.SubsumerDecompositionRule;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.SubsumerDecompositionRuleVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexedClassDecompositionRule
extends AbstractSubsumerDecompositionRule<IndexedDefinedClass> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(IndexedClassDecompositionRule.class);
    private static final IndexedClassDecompositionRule INSTANCE_ = new IndexedClassDecompositionRule();
    public static final String NAME = "Definition Expansion";

    public String toString() {
        return NAME;
    }

    public static SubsumerDecompositionRule<IndexedDefinedClass> getInstance() {
        return INSTANCE_;
    }

    public static boolean addRuleFor(ModifiableIndexedEquivalentClassesAxiom axiom, ModifiableOntologyIndex index, ElkAxiom reason) {
        ModifiableIndexedClassExpression definition = axiom.getSecondMember();
        if (definition instanceof ModifiableIndexedClass) {
            return false;
        }
        ModifiableIndexedDefinedClass definedClass = IndexedClassDecompositionRule.getDefinedClass(axiom);
        if (definedClass == null) {
            return false;
        }
        boolean success = index.tryAddDefinition(definedClass, definition, reason);
        if (LOGGER_.isTraceEnabled()) {
            if (success) {
                LOGGER_.trace("{}: added definition {} from {}", new Object[]{definedClass, definition, reason});
            } else {
                LOGGER_.trace("{}: defined multiple times", (Object)definedClass);
            }
        }
        return success;
    }

    public static boolean removeRuleFor(ModifiableIndexedEquivalentClassesAxiom axiom, ModifiableOntologyIndex index, ElkAxiom reason) {
        ModifiableIndexedClassExpression definition = axiom.getSecondMember();
        if (definition instanceof ModifiableIndexedClass) {
            return false;
        }
        ModifiableIndexedDefinedClass definedClass = IndexedClassDecompositionRule.getDefinedClass(axiom);
        if (definedClass == null) {
            return false;
        }
        boolean success = index.tryRemoveDefinition(definedClass, definition, reason);
        if (success && LOGGER_.isTraceEnabled()) {
            LOGGER_.trace("{}: removed definition {} from {}", new Object[]{definedClass, definition, reason});
        }
        return success;
    }

    static ModifiableIndexedDefinedClass getDefinedClass(ModifiableIndexedEquivalentClassesAxiom axiom) {
        ModifiableIndexedClassExpression firstMember = axiom.getFirstMember();
        if (firstMember instanceof ModifiableIndexedDefinedClass) {
            return (ModifiableIndexedDefinedClass)firstMember;
        }
        return null;
    }

    @Override
    public void apply(IndexedDefinedClass premise, ContextPremises premises, ClassInferenceProducer producer) {
        IndexedClassExpression definedExpression = this.getDefinition(premise);
        if (definedExpression == null) {
            return;
        }
        producer.produce(new SubClassInclusionExpandedDefinition(premises.getRoot(), premise, definedExpression, this.getDefinitionReason(premise)));
    }

    @Override
    public boolean isTracingRule() {
        return true;
    }

    @Override
    public void accept(SubsumerDecompositionRuleVisitor<?> visitor, IndexedDefinedClass premise, ContextPremises premises, ClassInferenceProducer producer) {
        visitor.visit(this, premise, premises, producer);
    }

    protected IndexedClassExpression getDefinition(IndexedDefinedClass premise) {
        return premise.getDefinition();
    }

    protected ElkAxiom getDefinitionReason(IndexedDefinedClass premise) {
        return premise.getDefinitionReason();
    }
}

