/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import org.semanticweb.elk.reasoner.saturation.SaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ContextAssignmentResetStage
extends AbstractReasonerStage {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ContextAssignmentResetStage.class);
    private int contextCountBefore_ = 0;

    public ContextAssignmentResetStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        super(reasoner, preStages);
    }

    @Override
    public String getName() {
        return "Context Reset";
    }

    @Override
    public boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        this.contextCountBefore_ = this.reasoner.saturationState.getContexts().size();
        return true;
    }

    @Override
    public void executeStage() throws ElkInterruptedException {
        SaturationStateWriter<? extends Context> writer = this.reasoner.saturationState.getContextModifyingWriter();
        writer.resetContexts();
    }

    @Override
    public boolean postExecute() {
        return super.postExecute();
    }

    @Override
    public void printInfo() {
        int contexResetCount = this.reasoner.saturationState.getContexts().size() - this.contextCountBefore_;
        if (contexResetCount > 0) {
            LOGGER_.debug("Contexts deleted: {}", (Object)contexResetCount);
        }
    }
}

