/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import org.semanticweb.elk.exceptions.ElkException;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.tracing.TracingComputation;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;

public class TracingStage
extends AbstractReasonerStage {
    private TracingComputation computation_ = null;

    public TracingStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        super(reasoner, preStages);
    }

    @Override
    public String getName() {
        return "Inference tracing";
    }

    @Override
    public void printInfo() {
        if (this.computation_ != null) {
            this.computation_.printStatistics();
        }
    }

    @Override
    public boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        this.computation_ = new TracingComputation(this.reasoner.getTraceState(), (InterruptMonitor)this.reasoner.getInterrupter(), this.reasoner.getProcessExecutor(), this.reasoner.getNumberOfWorkers(), this.reasoner.saturationState);
        return true;
    }

    @Override
    void executeStage() throws ElkException {
        this.computation_.process();
    }

    @Override
    public boolean postExecute() {
        if (!super.postExecute()) {
            return false;
        }
        this.computation_ = null;
        return true;
    }
}

