/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.reasoner.taxonomy.OrphanNode;
import org.semanticweb.elk.reasoner.taxonomy.OrphanTaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.impl.AbstractTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.ComparatorKeyProvider;
import org.semanticweb.elk.reasoner.taxonomy.model.NodeStore;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNodeFactory;

public class SingletoneTaxonomy<T extends ElkEntity, N extends OrphanTaxonomyNode<T>>
extends AbstractTaxonomy<T> {
    private final ComparatorKeyProvider<? super T> keyProvider_;
    final N node;

    public SingletoneTaxonomy(ComparatorKeyProvider<? super T> keyProvider, Collection<? extends T> allMembers, TaxonomyNodeFactory<T, N, Taxonomy<T>> nodeFactory) {
        this.keyProvider_ = keyProvider;
        this.node = (OrphanTaxonomyNode)nodeFactory.createNode(allMembers, allMembers.size(), this);
    }

    @Override
    public ComparatorKeyProvider<? super T> getKeyProvider() {
        return this.keyProvider_;
    }

    @Override
    public N getNode(T elkEntity) {
        if (((OrphanNode)this.node).contains(elkEntity)) {
            return this.node;
        }
        return null;
    }

    @Override
    public Set<? extends N> getNodes() {
        return Collections.singleton(this.node);
    }

    public N getTopNode() {
        return this.node;
    }

    public N getBottomNode() {
        return this.node;
    }

    @Override
    public boolean addListener(NodeStore.Listener<T> listener) {
        return true;
    }

    @Override
    public boolean removeListener(NodeStore.Listener<T> listener) {
        return true;
    }

    @Override
    public boolean addListener(Taxonomy.Listener<T> listener) {
        return true;
    }

    @Override
    public boolean removeListener(Taxonomy.Listener<T> listener) {
        return true;
    }
}

