/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.ArrayList;
import java.util.LinkedList;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassEntity;
import org.semanticweb.elk.reasoner.indexing.model.IndexedDefinedClass;
import org.semanticweb.elk.reasoner.indexing.model.IndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.model.IndexedPredefinedClass;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.NonBottomTaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableInstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableTaxonomy;
import org.semanticweb.elk.util.concurrent.computation.DelegateInterruptMonitor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;

class TaxonomyCleaningFactory
extends DelegateInterruptMonitor
implements InputProcessorFactory<IndexedClassEntity, InputProcessor<IndexedClassEntity>> {
    private final UpdateableTaxonomy<ElkClass> classTaxonomy_;
    private final UpdateableInstanceTaxonomy<ElkClass, ElkNamedIndividual> instanceTaxonomy_;

    TaxonomyCleaningFactory(InterruptMonitor interrupter, UpdateableTaxonomy<ElkClass> classTaxonomy, UpdateableInstanceTaxonomy<ElkClass, ElkNamedIndividual> instanceTaxonomy) {
        super(interrupter);
        this.classTaxonomy_ = classTaxonomy;
        this.instanceTaxonomy_ = instanceTaxonomy;
    }

    public InputProcessor<IndexedClassEntity> getEngine() {
        return new InputProcessor<IndexedClassEntity>(){
            private final IndexedClassEntity.Visitor<?> submissionVisitor_ = new IndexedClassEntity.Visitor<Object>(){

                @Override
                public Object visit(IndexedDefinedClass element) {
                    this.submitClass(element);
                    return null;
                }

                @Override
                public Object visit(IndexedPredefinedClass element) {
                    this.submitClass(element);
                    return null;
                }

                @Override
                public Object visit(IndexedIndividual element) {
                    this.submitIndividual(element);
                    return null;
                }
            };

            public void submit(IndexedClassEntity entity) {
                entity.accept(this.submissionVisitor_);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void submitClass(IndexedClass indexedClass) {
                TaxonomyNode typeNode;
                ArrayList<NonBottomTaxonomyNode<ElkClass>> subNodes;
                ElkClass elkClass = indexedClass.getElkEntity();
                if (elkClass == TaxonomyCleaningFactory.this.classTaxonomy_.getBottomNode().getCanonicalMember()) {
                    return;
                }
                TaxonomyNode taxonomyNode = TaxonomyCleaningFactory.this.classTaxonomy_.getBottomNode();
                synchronized (taxonomyNode) {
                    if (TaxonomyCleaningFactory.this.classTaxonomy_.removeFromBottomNode(elkClass)) {
                        return;
                    }
                }
                NonBottomTaxonomyNode<ElkClass> node = TaxonomyCleaningFactory.this.classTaxonomy_.getNonBottomNode(elkClass);
                if (node == null) {
                    return;
                }
                TaxonomyCleaningFactory.this.classTaxonomy_.removeDirectSupernodes(node);
                NonBottomTaxonomyNode<ElkClass> nonBottomTaxonomyNode = node;
                synchronized (nonBottomTaxonomyNode) {
                    subNodes = new ArrayList<NonBottomTaxonomyNode<ElkClass>>(node.getDirectNonBottomSubNodes());
                }
                for (NonBottomTaxonomyNode nonBottomTaxonomyNode2 : subNodes) {
                    TaxonomyCleaningFactory.this.classTaxonomy_.removeDirectSupernodes(nonBottomTaxonomyNode2);
                }
                if (TaxonomyCleaningFactory.this.instanceTaxonomy_ != null && (typeNode = TaxonomyCleaningFactory.this.instanceTaxonomy_.getNode((ElkEntity)elkClass)) != null) {
                    LinkedList linkedList;
                    Object var6_9 = null;
                    TaxonomyNode taxonomyNode2 = typeNode;
                    synchronized (taxonomyNode2) {
                        linkedList = new LinkedList(typeNode.getDirectInstanceNodes());
                    }
                    for (InstanceNode instanceNode : linkedList) {
                        if (!TaxonomyCleaningFactory.this.instanceTaxonomy_.removeDirectTypes(instanceNode)) continue;
                        TaxonomyCleaningFactory.this.instanceTaxonomy_.removeInstanceNode((ElkEntity)instanceNode.getCanonicalMember());
                    }
                }
                TaxonomyCleaningFactory.this.classTaxonomy_.removeNode((ElkEntity)node.getCanonicalMember());
                if (TaxonomyCleaningFactory.this.instanceTaxonomy_ != null) {
                    TaxonomyCleaningFactory.this.instanceTaxonomy_.removeNode((ElkEntity)node.getCanonicalMember());
                }
            }

            private void submitIndividual(IndexedIndividual indexedIndividual) {
                if (TaxonomyCleaningFactory.this.instanceTaxonomy_ != null) {
                    ElkNamedIndividual individual = indexedIndividual.getElkEntity();
                    InstanceNode node = TaxonomyCleaningFactory.this.instanceTaxonomy_.getInstanceNode(individual);
                    if (node != null && TaxonomyCleaningFactory.this.instanceTaxonomy_.removeDirectTypes(node)) {
                        TaxonomyCleaningFactory.this.instanceTaxonomy_.removeInstanceNode(individual);
                    }
                }
            }

            public void process() {
            }

            public void finish() {
            }
        };
    }

    public void finish() {
    }
}

