/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.reasoner.taxonomy.model.GenericInstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.GenericTaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.GenericTypeNode;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.collections.Operations;

public class TaxonomyNodeUtils {
    public static <N> Set<N> getAllReachable(Collection<? extends N> direct, Operations.Functor<N, Set<? extends N>> succ) {
        ArrayHashSet result = new ArrayHashSet(direct.size());
        result.addAll(direct);
        LinkedList<N> todo = new LinkedList<N>(direct);
        while (!todo.isEmpty()) {
            Object next = todo.poll();
            for (Object succNode : (Set)succ.apply(next)) {
                if (!result.add(succNode)) continue;
                todo.add(succNode);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public static <N, O> Set<O> collectFromAllReachable(Collection<? extends N> direct, Collection<? extends O> init, Operations.Functor<N, Set<? extends N>> succ, Operations.Functor<N, Set<? extends O>> collect) {
        ArrayHashSet result = new ArrayHashSet();
        result.addAll(init);
        ArrayHashSet queued = new ArrayHashSet();
        queued.addAll(direct);
        LinkedList<N> todo = new LinkedList<N>(direct);
        while (!todo.isEmpty()) {
            Object next = todo.poll();
            result.addAll((Collection)collect.apply(next));
            for (Object succNode : (Set)succ.apply(next)) {
                if (!queued.add(succNode)) continue;
                todo.add(succNode);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public static <T extends ElkEntity, N extends GenericTaxonomyNode<T, N>> Set<? extends N> getAllSuperNodes(Collection<? extends N> direct) {
        return TaxonomyNodeUtils.getAllReachable(direct, new Operations.Functor<N, Set<? extends N>>(){

            public Set<? extends N> apply(N node) {
                return node.getDirectSuperNodes();
            }
        });
    }

    public static <T extends ElkEntity, N extends GenericTaxonomyNode<T, N>> Set<? extends N> getAllSubNodes(Collection<? extends N> direct) {
        return TaxonomyNodeUtils.getAllReachable(direct, new Operations.Functor<N, Set<? extends N>>(){

            public Set<? extends N> apply(N node) {
                return node.getDirectSubNodes();
            }
        });
    }

    public static <T extends ElkEntity, I extends ElkEntity, TN extends GenericTypeNode<T, I, TN, IN>, IN extends GenericInstanceNode<T, I, TN, IN>> Set<? extends IN> getAllInstanceNodes(GenericTypeNode<T, I, TN, IN> node) {
        return TaxonomyNodeUtils.collectFromAllReachable(node.getDirectSubNodes(), node.getDirectInstanceNodes(), new Operations.Functor<GenericTypeNode<T, I, TN, IN>, Set<? extends GenericTypeNode<T, I, TN, IN>>>(){

            public Set<? extends TN> apply(GenericTypeNode<T, I, TN, IN> n) {
                return n.getDirectSubNodes();
            }
        }, new Operations.Functor<GenericTypeNode<T, I, TN, IN>, Set<? extends IN>>(){

            public Set<? extends IN> apply(GenericTypeNode<T, I, TN, IN> n) {
                return n.getDirectInstanceNodes();
            }
        });
    }
}

