/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy.hashing;

import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;

public class TaxonomyEqualator {
    public static <T extends ElkEntity> boolean equals(Taxonomy<T> taxonomy1, Taxonomy<T> taxonomy2) {
        if (taxonomy1 == null) {
            return taxonomy2 == null;
        }
        if (taxonomy2 == null) {
            return false;
        }
        Set<TaxonomyNode<T>> nodes1 = taxonomy1.getNodes();
        Set<TaxonomyNode<T>> nodes2 = taxonomy2.getNodes();
        if (nodes1.size() != nodes2.size()) {
            return false;
        }
        for (TaxonomyNode<T> node1 : nodes1) {
            ElkEntity thisMember = (ElkEntity)node1.getCanonicalMember();
            TaxonomyNode<ElkEntity> node2 = taxonomy2.getNode(thisMember);
            if (node2 == null) {
                return false;
            }
            if (node1.size() != node2.size()) {
                return false;
            }
            for (ElkEntity member : node1) {
                if (node2.contains(member)) continue;
                return false;
            }
            Set<TaxonomyNode<T>> parents1 = node1.getDirectSuperNodes();
            Set<TaxonomyNode<ElkEntity>> parents2 = node2.getDirectSuperNodes();
            if (parents1.size() != parents2.size()) {
                return false;
            }
            for (TaxonomyNode<T> parent1 : parents1) {
                TaxonomyNode<ElkEntity> parent2 = taxonomy2.getNode((ElkEntity)parent1.getCanonicalMember());
                if (parents2.contains(parent2)) continue;
                return false;
            }
            Set<TaxonomyNode<T>> children1 = node1.getDirectSubNodes();
            Set<TaxonomyNode<ElkEntity>> children2 = node2.getDirectSubNodes();
            if (children1.size() != children2.size()) {
                return false;
            }
            for (TaxonomyNode<T> child1 : children1) {
                TaxonomyNode<ElkEntity> child2 = taxonomy2.getNode((ElkEntity)child1.getCanonicalMember());
                if (children2.contains(child2)) continue;
                return false;
            }
        }
        return true;
    }
}

