/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy.impl;

import java.util.ArrayList;
import java.util.List;
import org.semanticweb.elk.reasoner.taxonomy.model.Node;
import org.semanticweb.elk.reasoner.taxonomy.model.NodeStore;

public abstract class AbstractNodeStore<T, N extends Node<T>>
implements NodeStore<T, N> {
    protected final List<NodeStore.Listener<T>> listeners_ = new ArrayList<NodeStore.Listener<T>>();

    @Override
    public boolean addListener(NodeStore.Listener<T> listener) {
        return this.listeners_.add(listener);
    }

    @Override
    public boolean removeListener(NodeStore.Listener<T> listener) {
        return this.listeners_.remove(listener);
    }

    protected void fireMemberForNodeAppeared(Node<T> node) {
        for (NodeStore.Listener listener : this.listeners_) {
            for (Object member : node) {
                listener.memberForNodeAppeared(member, node);
            }
        }
    }

    protected void fireMemberForNodeDisappeared(Node<T> node) {
        for (NodeStore.Listener listener : this.listeners_) {
            for (Object member : node) {
                listener.memberForNodeDisappeared(member, node);
            }
        }
    }
}

