/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.reasoner.taxonomy.impl.AbstractDistinctBottomTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.impl.UpdateableNodeStore;
import org.semanticweb.elk.reasoner.taxonomy.impl.UpdateableTaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.ComparatorKeyProvider;
import org.semanticweb.elk.reasoner.taxonomy.model.GenericTaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.Node;
import org.semanticweb.elk.reasoner.taxonomy.model.NodeFactory;
import org.semanticweb.elk.reasoner.taxonomy.model.NodeStore;
import org.semanticweb.elk.reasoner.taxonomy.model.NonBottomTaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNodeFactory;
import org.semanticweb.elk.util.collections.LazySetUnion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUpdateableGenericTaxonomy<T extends ElkEntity, N extends GenericTaxonomyNode<T, N>, UN extends UpdateableTaxonomyNode<T, N, UN>>
extends AbstractDistinctBottomTaxonomy<T, N, UN> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(AbstractUpdateableGenericTaxonomy.class);
    private final NodeFactory<T, UN> nodeFactory_;
    protected final UpdateableNodeStore<T, UN> nodeStore_;
    protected final T topMember_;
    protected final List<NodeStore.Listener<T>> nodeStoreListeners_;
    protected final List<Taxonomy.Listener<T>> taxonomyListeners_;

    public AbstractUpdateableGenericTaxonomy(UpdateableNodeStore<T, UN> nodeStore, final TaxonomyNodeFactory<T, UN, AbstractDistinctBottomTaxonomy<T, N, UN>> nodeFactory, T topMember) {
        this.nodeStore_ = nodeStore;
        this.nodeFactory_ = new NodeFactory<T, UN>(){

            @Override
            public UN createNode(Iterable<? extends T> members, int size) {
                return (UpdateableTaxonomyNode)nodeFactory.createNode(members, size, AbstractUpdateableGenericTaxonomy.this);
            }
        };
        this.topMember_ = topMember;
        this.taxonomyListeners_ = new ArrayList<Taxonomy.Listener<T>>();
        this.nodeStoreListeners_ = new ArrayList<NodeStore.Listener<T>>();
    }

    @Override
    public ComparatorKeyProvider<? super T> getKeyProvider() {
        return this.nodeStore_.getKeyProvider();
    }

    @Override
    public TaxonomyNode<T> getNode(T elkClass) {
        TaxonomyNode result = (TaxonomyNode)this.nodeStore_.getNode(elkClass);
        if (result == null && this.getBottomNode().contains(elkClass)) {
            result = this.getBottomNode();
        }
        return result;
    }

    public UN getNonBottomNode(T elkEntity) {
        return (UN)((UpdateableTaxonomyNode)this.nodeStore_.getNode(elkEntity));
    }

    @Override
    public Set<? extends TaxonomyNode<T>> getNodes() {
        return new LazySetUnion(this.nodeStore_.getNodes(), Collections.singleton(this.getBottomNode()));
    }

    @Override
    public Set<? extends UN> getNonBottomNodes() {
        return this.nodeStore_.getNodes();
    }

    public UN getTopNode() {
        return (UN)((UpdateableTaxonomyNode)this.nodeStore_.getNode(this.topMember_));
    }

    @Override
    public abstract N getBottomNode();

    public UN getCreateNode(Collection<? extends T> members) {
        return (UN)((UpdateableTaxonomyNode)this.nodeStore_.getCreateNode(members, members.size(), this.nodeFactory_));
    }

    @Override
    public boolean setCreateDirectSupernodes(NonBottomTaxonomyNode<T> subNode, Iterable<? extends Collection<? extends T>> superMemberSets) {
        UN node = this.toInternalNode(subNode);
        boolean isSuperMemberSetsEmpty = true;
        for (Collection<T> collection : superMemberSets) {
            NonBottomTaxonomyNode superNode = this.getCreateNode(collection);
            isSuperMemberSetsEmpty = false;
            this.addDirectRelation(superNode, node);
        }
        if (node.trySetAllParentsAssigned(true)) {
            if (!isSuperMemberSetsEmpty) {
                this.fireDirectSupernodeAssignment(subNode, subNode.getDirectSuperNodes());
            }
            return true;
        }
        return false;
    }

    protected void addDirectRelation(UN superNode, UN subNode) {
        subNode.addDirectSuperNode(superNode);
        superNode.addDirectSubNode(subNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeDirectSupernodes(NonBottomTaxonomyNode<T> subNode) {
        UpdateableTaxonomyNode node = this.toInternalNode(subNode);
        if (!node.trySetAllParentsAssigned(false)) {
            return false;
        }
        ArrayList superNodes = new ArrayList();
        Object object = node;
        synchronized (object) {
            superNodes.addAll(node.getDirectNonBottomSuperNodes());
            if (superNodes.isEmpty()) {
                return true;
            }
            for (UpdateableTaxonomyNode superNode : superNodes) {
                node.removeDirectSuperNode((UpdateableTaxonomyNode)superNode);
            }
        }
        object = superNodes.iterator();
        while (object.hasNext()) {
            UpdateableTaxonomyNode superNode;
            UpdateableTaxonomyNode updateableTaxonomyNode = superNode = (UpdateableTaxonomyNode)object.next();
            synchronized (updateableTaxonomyNode) {
                superNode.removeDirectSubNode(node);
            }
        }
        this.fireDirectSupernodeRemoval(subNode, superNodes);
        return true;
    }

    @Override
    public boolean removeNode(T member) {
        if (this.nodeStore_.removeNode(member)) {
            LOGGER_.trace("removed node with member: {}", member);
            return true;
        }
        return false;
    }

    @Override
    public boolean addToBottomNode(T member) {
        if (this.unsatisfiableClasses_.put(this.getKeyProvider().getKey(member), member) == null) {
            this.fireMemberForNodeAppeared(member, this.getBottomNode());
            return true;
        }
        return false;
    }

    @Override
    public boolean removeFromBottomNode(T member) {
        if (this.unsatisfiableClasses_.remove(this.getKeyProvider().getKey(member)) != null) {
            this.fireMemberForNodeDisappeared(member, this.getBottomNode());
            return true;
        }
        return false;
    }

    protected UN toInternalNode(NonBottomTaxonomyNode<T> node) {
        if (node.getTaxonomy() != this) {
            throw new IllegalArgumentException("The sub-node must belong to this taxonomy: " + node);
        }
        try {
            return (UN)((UpdateableTaxonomyNode)node);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("The sub-node must belong to this taxonomy: " + node);
        }
    }

    @Override
    public boolean addListener(NodeStore.Listener<T> listener) {
        return this.nodeStore_.addListener(listener) && this.nodeStoreListeners_.add(listener);
    }

    @Override
    public boolean removeListener(NodeStore.Listener<T> listener) {
        return this.nodeStore_.removeListener(listener) && this.nodeStoreListeners_.remove(listener);
    }

    @Override
    public boolean addListener(Taxonomy.Listener<T> listener) {
        return this.taxonomyListeners_.add(listener);
    }

    @Override
    public boolean removeListener(Taxonomy.Listener<T> listener) {
        return this.taxonomyListeners_.remove(listener);
    }

    protected void fireMemberForNodeAppeared(T member, Node<T> node) {
        for (NodeStore.Listener<T> listener : this.nodeStoreListeners_) {
            listener.memberForNodeAppeared(member, node);
        }
    }

    protected void fireMemberForNodeDisappeared(T member, Node<T> node) {
        for (NodeStore.Listener<T> listener : this.nodeStoreListeners_) {
            listener.memberForNodeDisappeared(member, node);
        }
    }

    protected void fireDirectSupernodeAssignment(TaxonomyNode<T> subNode, Collection<? extends TaxonomyNode<T>> superNodes) {
        for (Taxonomy.Listener<T> listener : this.taxonomyListeners_) {
            listener.directSuperNodesAppeared(subNode);
            for (TaxonomyNode<T> superNode : superNodes) {
                listener.directSubNodesAppeared(superNode);
            }
        }
    }

    protected void fireDirectSupernodeRemoval(TaxonomyNode<T> subNode, Collection<? extends TaxonomyNode<T>> superNodes) {
        for (Taxonomy.Listener<T> listener : this.taxonomyListeners_) {
            listener.directSuperNodesDisappeared(subNode);
            for (TaxonomyNode<T> superNode : superNodes) {
                listener.directSubNodesDisappeared(superNode);
            }
        }
    }
}

