/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy.impl;

import java.util.Collections;
import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyNodeUtils;
import org.semanticweb.elk.reasoner.taxonomy.impl.NonBottomGenericTypeNode;
import org.semanticweb.elk.reasoner.taxonomy.impl.SimpleUpdateableNode;
import org.semanticweb.elk.reasoner.taxonomy.impl.UpdateableInstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.impl.UpdateableTypeNode;
import org.semanticweb.elk.reasoner.taxonomy.model.GenericInstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.GenericTypeNode;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.hashing.HashGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IndividualNode<T extends ElkEntity, I extends ElkEntity, TN extends GenericTypeNode<T, I, TN, IN>, IN extends GenericInstanceNode<T, I, TN, IN>, UTN extends UpdateableTypeNode<T, I, TN, IN, UTN, UIN>, UIN extends UpdateableInstanceNode<T, I, TN, IN, UTN, UIN>>
extends SimpleUpdateableNode<I>
implements UpdateableInstanceNode<T, I, TN, IN, UTN, UIN> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(IndividualNode.class);
    final InstanceTaxonomy<T, I> taxonomy_;
    private final Set<UTN> directTypeNodes_;
    private final int hashCode_ = HashGenerator.generateNextHashCode();

    protected IndividualNode(InstanceTaxonomy<T, I> taxonomy, Iterable<? extends I> members, int size) {
        super(members, size, taxonomy.getInstanceKeyProvider());
        this.taxonomy_ = taxonomy;
        this.directTypeNodes_ = new ArrayHashSet();
    }

    @Override
    public synchronized void addDirectTypeNode(UTN typeNode) {
        LOGGER_.trace("{}: new direct type-node {}", (Object)this, typeNode);
        this.directTypeNodes_.add(typeNode);
    }

    @Override
    public Set<? extends TN> getDirectTypeNodes() {
        return Collections.unmodifiableSet(this.toTypeNodes(this.directTypeNodes_));
    }

    @Override
    public Set<? extends TN> getAllTypeNodes() {
        return TaxonomyNodeUtils.getAllSuperNodes(this.getDirectTypeNodes());
    }

    @Override
    public Taxonomy<T> getTaxonomy() {
        return this.taxonomy_;
    }

    protected abstract Set<? extends TN> toTypeNodes(Set<? extends UTN> var1);

    public final int hashCode() {
        return this.hashCode_;
    }

    @Override
    public String toString() {
        return ((ElkEntity)this.getCanonicalMember()).getIri().getFullIriAsString();
    }

    @Override
    public synchronized void removeDirectTypeNode(UTN typeNode) {
        LOGGER_.trace("{}: removing direct type node: {}", (Object)this, typeNode);
        this.directTypeNodes_.remove(typeNode);
    }

    @Override
    public Set<? extends UTN> getDirectNonBottomTypeNodes() {
        return this.directTypeNodes_;
    }

    public static class Projection2<T extends ElkEntity, I extends ElkEntity>
    extends IndividualNode<T, I, GenericTypeNode.Projection<T, I>, GenericInstanceNode.Projection<T, I>, NonBottomGenericTypeNode.Projection<T, I>, Projection2<T, I>>
    implements GenericInstanceNode.Projection<T, I> {
        public Projection2(InstanceTaxonomy<T, I> taxonomy, Iterable<? extends I> members, int size) {
            super(taxonomy, members, size);
        }

        @Override
        protected Set<? extends GenericTypeNode.Projection<T, I>> toTypeNodes(Set<? extends NonBottomGenericTypeNode.Projection<T, I>> nodes) {
            return nodes;
        }
    }

    public static class Projection<T extends ElkEntity, I extends ElkEntity>
    extends IndividualNode<T, I, GenericTypeNode.Projection<T, I>, GenericInstanceNode.Projection<T, I>, UpdateableTypeNode.Projection<T, I>, UpdateableInstanceNode.Projection<T, I>>
    implements UpdateableInstanceNode.Projection<T, I> {
        public Projection(InstanceTaxonomy<T, I> taxonomy, Iterable<? extends I> members, int size) {
            super(taxonomy, members, size);
        }

        @Override
        protected Set<? extends GenericTypeNode.Projection<T, I>> toTypeNodes(Set<? extends UpdateableTypeNode.Projection<T, I>> nodes) {
            return nodes;
        }
    }
}

