/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.semanticweb.elk.reasoner.taxonomy.model.ComparatorKeyProvider;
import org.semanticweb.elk.reasoner.taxonomy.model.Node;

public class SimpleNode<T>
implements Node<T> {
    protected final List<T> members_;
    private final ComparatorKeyProvider<? super T> keyProvider_;

    public SimpleNode(Iterable<? extends T> members, int size, ComparatorKeyProvider<? super T> keyProvider) {
        if (keyProvider == null) {
            throw new IllegalArgumentException("keyProvider cannot be null!");
        }
        this.keyProvider_ = keyProvider;
        if (members == null || size <= 0) {
            this.members_ = new ArrayList<T>();
        } else {
            this.members_ = new ArrayList<T>(size);
            for (T member : members) {
                this.members_.add(member);
            }
            Collections.sort(this.members_, this.getKeyProvider().getComparator());
        }
    }

    public SimpleNode(ComparatorKeyProvider<? super T> comparatorKeyProvider) {
        this(null, 0, comparatorKeyProvider);
    }

    @Override
    public ComparatorKeyProvider<? super T> getKeyProvider() {
        return this.keyProvider_;
    }

    @Override
    public Iterator<T> iterator() {
        return this.members_.iterator();
    }

    @Override
    public boolean contains(T member) {
        return Collections.binarySearch(this.members_, member, this.getKeyProvider().getComparator()) >= 0;
    }

    @Override
    public int size() {
        return this.members_.size();
    }

    @Override
    public T getCanonicalMember() {
        return this.members_.isEmpty() ? null : (T)this.members_.get(0);
    }

    public String toString() {
        return this.members_.toString();
    }
}

