/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.tracing;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.semanticweb.elk.exceptions.ElkRuntimeException;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.predefined.PredefinedElkClassFactory;
import org.semanticweb.elk.owl.visitors.ElkAxiomVisitor;
import org.semanticweb.elk.reasoner.config.ReasonerConfiguration;
import org.semanticweb.elk.reasoner.indexing.classes.ResolvingModifiableIndexedObjectFactory;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkAxiomConverter;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkAxiomConverterImpl;
import org.semanticweb.elk.reasoner.indexing.model.IndexedAxiom;
import org.semanticweb.elk.reasoner.indexing.model.IndexedAxiomInference;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.indexing.model.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.proof.ReasonerProducer;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationStateDummyChangeListener;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ClassConclusion;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ObjectPropertyConclusion;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubPropertyChain;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.inferences.ClassInference;
import org.semanticweb.elk.reasoner.saturation.inferences.SaturationInference;
import org.semanticweb.elk.reasoner.saturation.properties.inferences.ObjectPropertyInference;
import org.semanticweb.elk.reasoner.saturation.properties.inferences.SubPropertyChainTautology;
import org.semanticweb.elk.reasoner.stages.PropertyHierarchyCompositionState;
import org.semanticweb.elk.reasoner.tracing.Conclusion;
import org.semanticweb.elk.reasoner.tracing.DummyConclusionVisitor;
import org.semanticweb.elk.reasoner.tracing.ModifiableTracingProof;
import org.semanticweb.elk.reasoner.tracing.SynchronizedModifiableTracingProof;
import org.semanticweb.elk.reasoner.tracing.TracingInference;
import org.semanticweb.elk.reasoner.tracing.TracingInferenceDummyVisitor;
import org.semanticweb.elk.reasoner.tracing.TracingProof;
import org.semanticweb.elk.reasoner.tracing.factories.TracingJobListener;
import org.semanticweb.elk.util.collections.Evictor;
import org.semanticweb.elk.util.statistics.HasStats;
import org.semanticweb.elk.util.statistics.NestedStats;
import org.semanticweb.elk.util.statistics.ResetStats;
import org.semanticweb.elk.util.statistics.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceState
implements ReasonerProducer<ObjectPropertyInference>,
TracingProof,
HasStats {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(TraceState.class);
    private IndexedContextRoot toTrace_ = null;
    private final Map<Conclusion, Collection<? extends ClassInference>> classInferencesCache_ = new HashMap<Conclusion, Collection<? extends ClassInference>>();
    private final Evictor<Conclusion> classInferenceEvictor_;
    private final Set<ElkAxiom> indexedAxioms_ = new HashSet<ElkAxiom>();
    private final ModifiableTracingProof<ObjectPropertyInference> objectPropertyInferences_ = new SynchronizedModifiableTracingProof<ObjectPropertyInference>();
    private final ModifiableTracingProof<IndexedAxiomInference> indexedAxiomInferences_ = new SynchronizedModifiableTracingProof<IndexedAxiomInference>();
    private final SaturationInference.Visitor<Void> inferenceProducer_ = new InferenceProducer();
    private final Conclusion.Visitor<Collection<? extends TracingInference>> inferenceGetter_ = new InferenceGetter();
    private final ElkAxiomConverter elkAxiomConverter_;
    private final Stats stats_ = new Stats();
    private final Conclusion.Visitor<Boolean> requestedConclusionVisitor_ = new DummyConclusionVisitor<Boolean>(){

        @Override
        protected Boolean defaultVisit(Conclusion conclusion) {
            return true;
        }

        @Override
        protected Boolean defaultVisit(ClassConclusion conclusion) {
            TraceState.this.tracingListener_.lastRequestedConclusion_ = conclusion;
            TraceState.this.classInferenceEvictor_.add((Object)conclusion);
            Collection infs = (Collection)TraceState.this.classInferencesCache_.get(conclusion);
            if (infs != null) {
                ++((TraceState)TraceState.this).stats_.nCacheHits;
                TraceState.this.tracingListener_.inferencesOfLastRequestedConclusion_ = infs;
                return true;
            }
            ++((TraceState)TraceState.this).stats_.nCacheMisses;
            TraceState.this.toTrace_ = conclusion.getTraceRoot();
            return false;
        }
    };
    private final ThisTracingJobListener tracingListener_ = new ThisTracingJobListener();

    public Object getStats() {
        return this.stats_;
    }

    public <C extends Context> TraceState(ReasonerConfiguration config, SaturationState<C> saturationState, PropertyHierarchyCompositionState propertySaturationState, ElkObject.Factory elkFactory, ModifiableOntologyIndex index) {
        this.elkAxiomConverter_ = new ElkAxiomConverterImpl((PredefinedElkClassFactory)elkFactory, new ResolvingModifiableIndexedObjectFactory(index), index, 0, this.indexedAxiomInferences_);
        saturationState.addListener(new SaturationStateDummyChangeListener<C>(){

            @Override
            public void contextsClear() {
                TraceState.this.clearClassInferences();
                TraceState.this.clearIndexedAxiomInferences();
            }

            @Override
            public void contextMarkedNonSaturated(C context) {
                TraceState.this.clearClassInferences();
                TraceState.this.clearIndexedAxiomInferences();
            }
        });
        propertySaturationState.addListener(new PropertyHierarchyCompositionState.Listener(){

            @Override
            public void propertyBecameSaturated(IndexedPropertyChain chain) {
            }

            @Override
            public void propertyBecameNotSaturated(IndexedPropertyChain chain) {
                TraceState.this.clearObjectPropertyInferences();
                TraceState.this.clearIndexedAxiomInferences();
            }
        });
        Object builder = config.getParameter("elk.reasoner.tracing.evictor");
        LOGGER_.debug("{}={}", (Object)"elk.reasoner.tracing.evictor", builder);
        this.classInferenceEvictor_ = ((Evictor.Builder)builder).build();
    }

    public synchronized boolean requestInferences(Conclusion conclusion) {
        LOGGER_.trace("{}: request inferences", (Object)conclusion);
        return conclusion.accept(this.requestedConclusionVisitor_);
    }

    public synchronized IndexedContextRoot pollToTrace() {
        IndexedContextRoot result = this.toTrace_;
        this.toTrace_ = null;
        return result;
    }

    public TracingJobListener getTracingListener() {
        return this.tracingListener_;
    }

    private void clearClassInferences() {
        this.classInferencesCache_.clear();
        this.tracingListener_.inferencesOfLastRequestedConclusion_ = null;
    }

    private void clearObjectPropertyInferences() {
        this.objectPropertyInferences_.clear();
    }

    private void clearIndexedAxiomInferences() {
        this.indexedAxiomInferences_.clear();
        this.indexedAxioms_.clear();
    }

    @Override
    public Collection<? extends TracingInference> getInferences(Object conclusion) {
        if (conclusion instanceof Conclusion) {
            return ((Conclusion)conclusion).accept(this.inferenceGetter_);
        }
        return Collections.emptySet();
    }

    @Override
    public void produce(ObjectPropertyInference inference) {
        inference.accept(this.inferenceProducer_);
    }

    synchronized void indexAxiom(ElkAxiom axiom) {
        if (!this.indexedAxioms_.add(axiom)) {
            return;
        }
        axiom.accept((ElkAxiomVisitor)this.elkAxiomConverter_);
    }

    private class InferenceProducer
    extends TracingInferenceDummyVisitor<Void> {
        private InferenceProducer() {
        }

        @Override
        protected Void defaultVisit(ObjectPropertyInference inference) {
            TraceState.this.objectPropertyInferences_.produce(inference);
            return null;
        }
    }

    private class InferenceGetter
    extends DummyConclusionVisitor<Collection<? extends TracingInference>> {
        private InferenceGetter() {
        }

        @Override
        protected Collection<? extends ClassInference> defaultVisit(ClassConclusion conclusion) {
            if (!conclusion.equals(TraceState.this.tracingListener_.lastRequestedConclusion_) || TraceState.this.tracingListener_.inferencesOfLastRequestedConclusion_ == null) {
                throw new ElkRuntimeException("Conclusion not traced: " + conclusion);
            }
            return TraceState.this.tracingListener_.inferencesOfLastRequestedConclusion_;
        }

        @Override
        protected Collection<? extends ObjectPropertyInference> defaultVisit(ObjectPropertyConclusion conclusion) {
            return TraceState.this.objectPropertyInferences_.getInferences(conclusion);
        }

        @Override
        public Collection<? extends TracingInference> visit(SubPropertyChain conclusion) {
            Collection infs = (Collection)super.visit(conclusion);
            if (infs.iterator().hasNext()) {
                return infs;
            }
            IndexedPropertyChain subChain = conclusion.getSubChain();
            if (conclusion.getSuperChain().equals(subChain)) {
                return Collections.singleton(new SubPropertyChainTautology(subChain));
            }
            return infs;
        }

        @Override
        protected Collection<? extends IndexedAxiomInference> defaultVisit(IndexedAxiom conclusion) {
            TraceState.this.indexAxiom(conclusion.getOriginalAxiom());
            return TraceState.this.indexedAxiomInferences_.getInferences(conclusion);
        }
    }

    private class ThisTracingJobListener
    implements TracingJobListener {
        private ClassConclusion lastRequestedConclusion_ = null;
        private Collection<? extends ClassInference> inferencesOfLastRequestedConclusion_ = null;

        private ThisTracingJobListener() {
        }

        @Override
        public synchronized void notifyJobFinished(IndexedContextRoot root, ModifiableTracingProof<ClassInference> proof) {
            for (Conclusion concl : proof.getAllConclusions()) {
                Collection tracedInfs = proof.getInferences(concl);
                if (concl.equals(this.lastRequestedConclusion_)) {
                    this.inferencesOfLastRequestedConclusion_ = tracedInfs;
                }
                if (tracedInfs.isEmpty() || TraceState.this.classInferencesCache_.containsKey(concl)) continue;
                TraceState.this.classInferencesCache_.put(concl, tracedInfs);
                Iterator evictedConclusions = TraceState.this.classInferenceEvictor_.addAndEvict((Object)concl);
                while (evictedConclusions.hasNext()) {
                    TraceState.this.classInferencesCache_.remove(evictedConclusions.next());
                }
            }
        }
    }

    public class Stats {
        @Stat
        public int nCacheHits = 0;
        @Stat
        public int nCacheMisses = 0;

        @ResetStats
        public void resetStats() {
            this.nCacheHits = 0;
            this.nCacheMisses = 0;
        }

        @NestedStats(name="evictor")
        public Object getRecentConclusionsStats() {
            return TraceState.this.classInferenceEvictor_.getStats();
        }
    }
}

