/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.tracing.factories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.semanticweb.elk.reasoner.proof.ReasonerProducer;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ClassConclusion;
import org.semanticweb.elk.reasoner.saturation.inferences.ClassInference;
import org.semanticweb.elk.reasoner.tracing.ConclusionBaseFactory;
import org.semanticweb.elk.reasoner.tracing.DummyConclusionVisitor;
import org.semanticweb.elk.reasoner.tracing.ModifiableTracingProof;
import org.semanticweb.elk.reasoner.tracing.TracingInference;
import org.semanticweb.elk.reasoner.tracing.factories.ClassInferenceConclusionGettingVisitor;
import org.semanticweb.elk.reasoner.tracing.factories.ClassInferenceLocalPremiseVisitor;
import org.semanticweb.elk.reasoner.tracing.factories.ConclusionEqualityChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClassInferenceBlockingFilter
implements ReasonerProducer<ClassInference> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ClassInferenceBlockingFilter.class);
    private static final ClassConclusion.Factory CONCLUSION_FACTORY_ = new ConclusionBaseFactory();
    private static final ClassInference.Visitor<ClassConclusion> CONCLUSION_GETTER_ = new ClassInferenceConclusionGettingVisitor(CONCLUSION_FACTORY_);
    private final ModifiableTracingProof<ClassInference> output_;
    private final Map<ClassConclusion, List<ClassInference>> blocked_ = new HashMap<ClassConclusion, List<ClassInference>>();
    private final Queue<ClassInference> unblocked_ = new LinkedList<ClassInference>();

    ClassInferenceBlockingFilter(ModifiableTracingProof<ClassInference> output) {
        this.output_ = output;
    }

    @Override
    public void produce(ClassInference next) {
        this.checkBlocked(next);
        while ((next = this.unblocked_.poll()) != null) {
            this.output_.produce(next);
            List<ClassInference> blockedByNext = this.blocked_.remove(ClassInferenceBlockingFilter.getConclusion(next));
            if (blockedByNext == null) continue;
            for (ClassInference inf : blockedByNext) {
                this.checkBlocked(inf);
            }
        }
    }

    private void checkBlocked(ClassInference inference) {
        if (ClassInferenceBlockingFilter.hasPremise(inference, ClassInferenceBlockingFilter.getConclusion(inference))) {
            LOGGER_.trace("{}: permanently blocked", (Object)inference);
            return;
        }
        ClassConclusion blockedPremise = this.getBlockedPremise(inference);
        if (blockedPremise == null) {
            LOGGER_.trace("{}: unblocked", (Object)inference);
            this.unblocked_.add(inference);
        } else {
            LOGGER_.trace("{}: blocked by {}", (Object)inference, (Object)blockedPremise);
            this.block(inference, blockedPremise);
        }
    }

    private void block(ClassInference inference, ClassConclusion conclusion) {
        List<ClassInference> blockedForConclusion = this.blocked_.get(conclusion);
        if (blockedForConclusion == null) {
            blockedForConclusion = new ArrayList<ClassInference>();
            this.blocked_.put(conclusion, blockedForConclusion);
        }
        blockedForConclusion.add(inference);
    }

    private static ClassConclusion getConclusion(ClassInference inference) {
        return inference.accept(CONCLUSION_GETTER_);
    }

    private static boolean hasPremise(ClassInference inference, ClassConclusion premise) {
        ConclusionEqualityChecker checker = new ConclusionEqualityChecker(premise);
        inference.accept(new ClassInferenceLocalPremiseVisitor(CONCLUSION_FACTORY_, checker));
        return checker.getResult();
    }

    private ClassConclusion getBlockedPremise(ClassInference inference) {
        DerivabilityChecker checker = new DerivabilityChecker(ClassInferenceBlockingFilter.getConclusion(inference));
        inference.accept(new ClassInferenceLocalPremiseVisitor(CONCLUSION_FACTORY_, checker));
        return checker.getResult();
    }

    private boolean derivableWithoutPremise(ClassConclusion conclusion, ClassConclusion premise) {
        for (TracingInference inf : this.output_.getInferences(conclusion)) {
            if (ClassInferenceBlockingFilter.hasPremise((ClassInference)inf, premise)) continue;
            return true;
        }
        return false;
    }

    private class DerivabilityChecker
    extends DummyConclusionVisitor<Void> {
        private final ClassConclusion premise_;
        private ClassConclusion result_ = null;

        DerivabilityChecker(ClassConclusion premise) {
            this.premise_ = premise;
        }

        @Override
        protected Void defaultVisit(ClassConclusion candidate) {
            if (this.result_ == null && !ClassInferenceBlockingFilter.this.derivableWithoutPremise(candidate, this.premise_)) {
                this.result_ = candidate;
            }
            return null;
        }

        ClassConclusion getResult() {
            return this.result_;
        }
    }
}

