/*
 * Decompiled with CFR 0.152.
 */
package openllet.aterm.pure.binary;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import openllet.aterm.AFun;
import openllet.aterm.ATerm;
import openllet.aterm.ATermList;
import openllet.aterm.ParseError;
import openllet.aterm.pure.PureFactory;
import openllet.aterm.pure.binary.SymEntry;
import openllet.shared.tools.Log;

public class BAFReader {
    public static final Logger _logger = Log.getLogger(BAFReader.class);
    private static final int BAF_MAGIC = 2991;
    private static final int BAF_VERSION = 768;
    private static final int HEADER_BITS = 32;
    private final BitStream _reader;
    private int _nrUniqueSymbols = -1;
    private SymEntry[] _symbols;
    private final PureFactory _factory;
    public static boolean _isDebugging = false;
    private int _level = 0;

    public BAFReader(PureFactory factory, InputStream inputStream) {
        this._factory = factory;
        this._reader = new BitStream(inputStream);
    }

    public ATerm readFromBinaryFile(boolean headerAlreadyRead) throws ParseError, IOException {
        if (!headerAlreadyRead && !BAFReader.isBinaryATerm(this._reader)) {
            throw new ParseError("Input is not a BAF file");
        }
        int val = this._reader.readInt();
        if (val != 768) {
            throw new ParseError("Wrong BAF version (wanted 768, got " + val + "), giving up");
        }
        this._nrUniqueSymbols = this._reader.readInt();
        int nrUniqueTerms = this._reader.readInt();
        if (BAFReader.isDebugging()) {
            BAFReader.debug(this._nrUniqueSymbols + " unique symbols");
            BAFReader.debug(nrUniqueTerms + " unique terms");
        }
        this._symbols = new SymEntry[this._nrUniqueSymbols];
        this.readAllSymbols();
        int i = this._reader.readInt();
        return this.readTerm(this._symbols[i]);
    }

    private static boolean isDebugging() {
        return _isDebugging;
    }

    public static boolean isBinaryATerm(BufferedInputStream in) throws IOException {
        return BAFReader.isBinaryATerm(new BitStream(in));
    }

    private static boolean isBinaryATerm(BitStream in) throws IOException {
        try {
            int w1 = in.readInt();
            return w1 == 2991;
        }
        catch (EOFException e) {
            _logger.log(Level.FINE, "", e);
            return false;
        }
    }

    private static void debug(String s) {
        _logger.fine(s);
    }

    private ATerm readTerm(SymEntry e) throws ParseError, IOException {
        ATerm[] name;
        int arity = e.arity;
        ATerm[] args = new ATerm[arity];
        ++this._level;
        if (BAFReader.isDebugging()) {
            BAFReader.debug("readTerm()/" + this._level + " - " + e.fun.getName() + "[" + arity + "]");
        }
        for (int i = 0; i < arity; ++i) {
            int val = this._reader.readBits(e.symWidth[i]);
            if (BAFReader.isDebugging()) {
                BAFReader.debug(" [" + i + "] - " + val);
                BAFReader.debug(" [" + i + "] - " + e.topSyms[i].length);
            }
            SymEntry argSym = this._symbols[e.topSyms[i][val]];
            val = this._reader.readBits(argSym.termWidth);
            if (argSym.terms[val] == null) {
                if (BAFReader.isDebugging()) {
                    BAFReader.debug(" [" + i + "] - recurse");
                }
                argSym.terms[val] = this.readTerm(argSym);
            }
            if (argSym.terms[val] == null) {
                throw new ParseError("Cannot be null");
            }
            args[i] = argSym.terms[val];
        }
        switch (name = e.fun.getName()) {
            case "<int>": {
                int val = this._reader.readBits(32);
                --this._level;
                return this._factory.makeInt(val);
            }
            case "<real>": {
                this._reader.flushBitsFromReader();
                String s = this._reader.readString();
                --this._level;
                return this._factory.makeReal(new Double(s));
            }
            case "[_,_]": {
                if (BAFReader.isDebugging()) {
                    BAFReader.debug("--");
                    for (ATerm arg : args) {
                        BAFReader.debug(" + " + arg.getClass());
                    }
                }
                --this._level;
                return ((ATermList)args[1]).insert(args[0]);
            }
            case "[]": {
                --this._level;
                return this._factory.makeList();
            }
            case "<_>": {
                return this._factory.makePlaceholder(args[0]);
            }
        }
        if (BAFReader.isDebugging()) {
            BAFReader.debug(e.fun + " / " + args);
            for (ATerm arg : args) {
                BAFReader.debug("" + arg);
            }
        }
        --this._level;
        return this._factory.makeAppl(e.fun, args);
    }

    private void readAllSymbols() throws IOException {
        for (int i = 0; i < this._nrUniqueSymbols; ++i) {
            int v;
            AFun fun;
            SymEntry e;
            this._symbols[i] = e = new SymEntry();
            e.fun = fun = this.readSymbol();
            int arity = e.arity = fun.getArity();
            e.nrTerms = v = this._reader.readInt();
            e.termWidth = BAFReader.bitWidth(v);
            ATerm[] aTermArray = e.terms = v == 0 ? null : new ATerm[v];
            if (arity == 0) {
                e.nrTopSyms = null;
                e.symWidth = null;
                e.topSyms = null;
            } else {
                e.nrTopSyms = new int[arity];
                e.symWidth = new int[arity];
                e.topSyms = new int[arity][];
            }
            for (int j = 0; j < arity; ++j) {
                e.nrTopSyms[j] = v = this._reader.readInt();
                e.symWidth[j] = BAFReader.bitWidth(v);
                e.topSyms[j] = new int[v];
                for (int k = 0; k < e.nrTopSyms[j]; ++k) {
                    e.topSyms[j][k] = v = this._reader.readInt();
                }
            }
        }
    }

    private static int bitWidth(int vBit) {
        int v = vBit;
        int nrBits = 0;
        if (v <= 1) {
            return 0;
        }
        while (v != 0) {
            v >>= 1;
            ++nrBits;
        }
        return nrBits;
    }

    private AFun readSymbol() throws IOException {
        String s = this._reader.readString();
        int arity = this._reader.readInt();
        int quoted = this._reader.readInt();
        if (BAFReader.isDebugging()) {
            BAFReader.debug(s + " / " + arity + " / " + quoted);
        }
        return this._factory.makeAFun(s, arity, quoted != 0);
    }

    public static class BitStream {
        private final InputStream _stream;
        private int _bitsInBuffer;
        private int _bitBuffer;

        public BitStream(InputStream inputStream) {
            this._stream = inputStream;
        }

        public int readInt() throws IOException {
            int[] buf = new int[5];
            buf[0] = this.readByte();
            if ((buf[0] & 0x80) == 0) {
                return buf[0];
            }
            buf[1] = this.readByte();
            if ((buf[0] & 0x40) == 0) {
                return buf[1] + ((buf[0] & 0xFFFFFF3F) << 8);
            }
            buf[2] = this.readByte();
            if ((buf[0] & 0x20) == 0) {
                return buf[2] + (buf[1] << 8) + ((buf[0] & 0xFFFFFF1F) << 16);
            }
            buf[3] = this.readByte();
            if ((buf[0] & 0x10) == 0) {
                return buf[3] + (buf[2] << 8) + (buf[1] << 16) + ((buf[0] & 0xFFFFFF0F) << 24);
            }
            buf[4] = this.readByte();
            return buf[4] + (buf[3] << 8) + (buf[2] << 16) + (buf[1] << 24);
        }

        private int readByte() throws IOException {
            int c = this._stream.read();
            if (c == -1) {
                throw new EOFException();
            }
            return c;
        }

        public String readString() throws IOException {
            int l = this.readInt();
            byte[] b = new byte[l];
            for (int v = 0; v < b.length; v += this._stream.read(b, v, b.length - v)) {
            }
            return new String(b);
        }

        public int readBits(int nrBits) throws IOException {
            int mask = 1;
            int val = 0;
            for (int i = 0; i < nrBits; ++i) {
                if (this._bitsInBuffer == 0) {
                    int v = this.readByte();
                    if (v == -1) {
                        return -1;
                    }
                    this._bitBuffer = v;
                    this._bitsInBuffer = 8;
                }
                val |= (this._bitBuffer & 0x80) != 0 ? mask : 0;
                mask <<= 1;
                this._bitBuffer <<= 1;
                --this._bitsInBuffer;
            }
            return val;
        }

        public void flushBitsFromReader() {
            this._bitsInBuffer = 0;
        }
    }
}

