/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.semanticweb.owlapi.model.HasAxioms;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class DefinitionTracker
implements OWLOntologyChangeListener {
    private final Map<OWLEntity, AtomicInteger> referenceCounts = new HashMap<OWLEntity, AtomicInteger>();
    private final OWLOntology ontology;
    private final Set<OWLAxiom> axioms = new HashSet<OWLAxiom>();

    public DefinitionTracker(OWLOntology ontology) {
        this.ontology = OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null");
        ontology.importsClosure().flatMap(HasAxioms::axioms).forEach(this::addAxiom);
        ontology.getOWLOntologyManager().addOntologyChangeListener(this);
    }

    private void addAxiom(OWLAxiom axiom) {
        if (this.axioms.add(axiom)) {
            axiom.signature().forEach(e -> this.referenceCounts.computeIfAbsent((OWLEntity)e, x -> new AtomicInteger(0)).incrementAndGet());
        }
    }

    private void removeAxiom(OWLAxiom axiom) {
        if (this.axioms.remove(axiom)) {
            axiom.signature().forEach(e -> {
                AtomicInteger count = this.referenceCounts.get(e);
                if (count != null && count.decrementAndGet() == 0) {
                    this.referenceCounts.remove(e);
                }
            });
        }
    }

    public boolean isDefined(OWLEntity entity) {
        return OWLAPIPreconditions.checkNotNull(entity, "entity cannot be null").isBuiltIn() || this.referenceCounts.containsKey(entity);
    }

    public boolean isDefined(OWLClassExpression classExpression) {
        OWLAPIPreconditions.checkNotNull(classExpression, "classExpression cannot be null");
        return !classExpression.signature().anyMatch(e -> !this.isDefined((OWLEntity)e));
    }

    @Override
    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange() || !OWLAPIStreamUtils.contains(this.ontology.importsClosure(), oWLOntologyChange.getOntology())) continue;
            OWLAxiom axiom = oWLOntologyChange.getAxiom();
            if (oWLOntologyChange.isAddAxiom()) {
                this.addAxiom(axiom);
                continue;
            }
            if (oWLOntologyChange.isRemoveAxiom()) {
                this.removeAxiom(axiom);
                continue;
            }
            throw new UnsupportedOperationException("Unrecognized axiom change: " + oWLOntologyChange);
        }
    }
}

