/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.rdf.api.BlankNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class RDFResourceBlankNode
extends RDFResource
implements BlankNode {
    private static final UUID UNIQUE_BASE = UUID.randomUUID();
    private final IRI resource;
    private final boolean isIndividual;
    private final boolean isAxiom;
    private final boolean forceIdOutput;

    public RDFResourceBlankNode(IRI resource, boolean isIndividual, boolean forceId, boolean isAxiom) {
        this.resource = OWLAPIPreconditions.checkNotNull(resource, "resource cannot be null");
        this.isIndividual = isIndividual;
        this.isAxiom = isAxiom;
        this.forceIdOutput = forceId;
    }

    public RDFResourceBlankNode(Integer anonId, boolean isIndividual, boolean forceId, boolean isAxiom) {
        this(NodeID.nodeId(anonId), isIndividual, forceId, isAxiom);
    }

    public RDFResourceBlankNode(boolean isIndividual, boolean forceId, boolean isAxiom) {
        this(NodeID.nextFreshNodeId(), isIndividual, forceId, isAxiom);
    }

    @Override
    public boolean isIndividual() {
        return this.isIndividual;
    }

    @Override
    public boolean isAxiom() {
        return this.isAxiom;
    }

    @Override
    public boolean shouldOutputId() {
        return this.forceIdOutput;
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public boolean isAnonymous() {
        return true;
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RDFResourceBlankNode) {
            RDFResourceBlankNode other = (RDFResourceBlankNode)obj;
            return this.resource.equals(other.resource);
        }
        if (obj instanceof BlankNode) {
            BlankNode blankNode = (BlankNode)obj;
            return this.uniqueReference().equals(blankNode.uniqueReference());
        }
        return false;
    }

    public String toString() {
        return this.resource.toString();
    }

    @Override
    public IRI getIRI() {
        return this.resource;
    }

    @Override
    public IRI getResource() {
        return this.resource;
    }

    public String uniqueReference() {
        String nodeId = this.resource.getIRIString().replace("_:", "");
        return UNIQUE_BASE + ":" + nodeId;
    }

    @Override
    public String getNodeIDValue() {
        return NodeID.stripArtifacts(this.resource);
    }
}

