/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyCharacteristicAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.InferredObjectPropertyAxiomGenerator;
import org.semanticweb.owlapi.util.OWLObjectPropertyManager;

public class InferredObjectPropertyCharacteristicAxiomGenerator
extends InferredObjectPropertyAxiomGenerator<OWLObjectPropertyCharacteristicAxiom> {
    private static boolean triviallyTransitiveCheck(OWLObjectProperty property, OWLReasoner reasoner, OWLDataFactory df) {
        OWLObjectSomeValuesFrom chain = df.getOWLObjectSomeValuesFrom(property, df.getOWLObjectSomeValuesFrom(property, df.getOWLThing()));
        return !reasoner.isSatisfiable(chain);
    }

    protected static void addIfEntailed(OWLObjectPropertyCharacteristicAxiom axiom, OWLReasoner reasoner, Set<OWLObjectPropertyCharacteristicAxiom> result) {
        if (reasoner.isEntailmentCheckingSupported(axiom.getAxiomType()) && reasoner.isEntailed((OWLAxiom)axiom)) {
            result.add(axiom);
        }
    }

    @Override
    protected void addAxioms(OWLObjectProperty entity, OWLReasoner reasoner, OWLDataFactory df, Set<OWLObjectPropertyCharacteristicAxiom> result, Set<OWLObjectPropertyExpression> nonSimpleProperties) {
        InferredObjectPropertyCharacteristicAxiomGenerator.addIfEntailed(df.getOWLSymmetricObjectPropertyAxiom(entity), reasoner, result);
        InferredObjectPropertyCharacteristicAxiomGenerator.addIfEntailed(df.getOWLReflexiveObjectPropertyAxiom(entity), reasoner, result);
        if (this.simple(entity, reasoner)) {
            InferredObjectPropertyCharacteristicAxiomGenerator.addIfEntailed(df.getOWLFunctionalObjectPropertyAxiom(entity), reasoner, result);
            InferredObjectPropertyCharacteristicAxiomGenerator.addIfEntailed(df.getOWLInverseFunctionalObjectPropertyAxiom(entity), reasoner, result);
            InferredObjectPropertyCharacteristicAxiomGenerator.addIfEntailed(df.getOWLAsymmetricObjectPropertyAxiom(entity), reasoner, result);
            InferredObjectPropertyCharacteristicAxiomGenerator.addTransitiveAxiomIfEntailed(entity, reasoner, df, result);
            InferredObjectPropertyCharacteristicAxiomGenerator.addIfEntailed(df.getOWLIrreflexiveObjectPropertyAxiom(entity), reasoner, result);
        }
    }

    protected boolean simple(OWLObjectProperty entity, OWLReasoner reasoner) {
        OWLOntology current = reasoner.getRootOntology();
        OWLObjectPropertyManager objectPropertyManager = new OWLObjectPropertyManager(current);
        return !objectPropertyManager.isNonSimple(entity);
    }

    protected static void addTransitiveAxiomIfEntailed(OWLObjectProperty p, OWLReasoner r, OWLDataFactory df, Set<OWLObjectPropertyCharacteristicAxiom> result) {
        OWLTransitiveObjectPropertyAxiom axiom = df.getOWLTransitiveObjectPropertyAxiom(p);
        if (r.isEntailmentCheckingSupported(axiom.getAxiomType()) && r.isEntailed((OWLAxiom)axiom) && !InferredObjectPropertyCharacteristicAxiomGenerator.triviallyTransitiveCheck(p, r, df)) {
            result.add(axiom);
        }
    }

    @Override
    public String getLabel() {
        return "Object property characteristics";
    }
}

