/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.decomposition;

import java.util.List;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapitools.decomposition.AxiomWrapper;

public class AxiomSelector {
    private AxiomSelector() {
    }

    public static List<OWLAxiom> selectAxioms(OWLOntology o) {
        return AxiomSelector.selectAxioms(o, false);
    }

    public static List<OWLAxiom> selectAxioms(OWLOntology o, boolean excludeAssertions) {
        Stream<Object> types = AxiomType.LOGICAL_AXIOMS_AND_DECLARATIONS_TYPES.stream();
        if (excludeAssertions) {
            types = types.filter(x -> !AxiomType.ABoxAxiomTypes.contains(x));
        }
        return OWLAPIStreamUtils.asList(types.flatMap(type -> o.axioms(type, Imports.INCLUDED)));
    }

    public static List<AxiomWrapper> wrap(List<OWLAxiom> o) {
        return OWLAPIStreamUtils.asList(o.stream().map(AxiomWrapper::new));
    }
}

