/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import uk.ac.manchester.cs.owl.owlapi.InternalizedEntities;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

public class OWLLiteralImplPlain
extends OWLObjectImpl
implements OWLLiteral {
    private final String literal;
    private final OWLDatatype datatype;
    private final String lang;

    public OWLLiteralImplPlain(String literal, @Nullable String lang) {
        this.literal = literal;
        if (lang == null || lang.isEmpty()) {
            this.lang = "";
            this.datatype = InternalizedEntities.XSDSTRING;
        } else {
            this.lang = lang.trim();
            this.datatype = InternalizedEntities.LANGSTRING;
        }
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    @Override
    public boolean hasLang() {
        return !this.lang.isEmpty();
    }

    @Override
    public boolean isRDFPlainLiteral() {
        return false;
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    @Override
    public boolean hasLang(@Nullable String l) {
        if (l == null || l.isEmpty()) {
            return this.lang.isEmpty();
        }
        return this.lang.equalsIgnoreCase(l.trim());
    }

    @Override
    public OWLDatatype getDatatype() {
        return this.datatype;
    }

    @Override
    public int initHashCode() {
        int hash = this.hashIndex();
        hash = OWLObject.hashIteration(hash, this.getDatatype().hashCode());
        hash = OWLObject.hashIteration(hash, this.specificHash() * 65536);
        return OWLObject.hashIteration(hash, this.getLang().hashCode());
    }

    private int specificHash() {
        try {
            if (this.isInteger()) {
                return this.parseInteger();
            }
            if (this.isDouble()) {
                return (int)this.parseDouble();
            }
            if (this.isFloat()) {
                return (int)this.parseFloat();
            }
            if (this.isBoolean()) {
                return this.parseBoolean() ? 1 : 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.getLiteral().hashCode();
    }
}

