/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.concurrent.computation;

import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.semanticweb.elk.util.concurrent.computation.ComputationRuntimeException;
import org.semanticweb.elk.util.concurrent.computation.ConcurrentExecutor;
import org.semanticweb.elk.util.concurrent.computation.JobMonitor;

class ConcurrentExecutorImpl
implements ConcurrentExecutor {
    private final Executor executor_;

    ConcurrentExecutorImpl(Executor executor) {
        this.executor_ = executor;
    }

    ConcurrentExecutorImpl(String prefix, long timeout, TimeUnit unit) {
        int cores = Runtime.getRuntime().availableProcessors();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(cores, Integer.MAX_VALUE, timeout, unit, new LinkedBlockingQueue<Runnable>());
        executor.setThreadFactory(new JobThreadFactory(prefix));
        this.executor_ = executor;
    }

    @Override
    public synchronized JobMonitor submit(Runnable job, int noInstances) {
        ThisJobMonitor result = new ThisJobMonitor(job, noInstances);
        for (int i = 0; i < noInstances; ++i) {
            this.executor_.execute(result);
        }
        return result;
    }

    private static class JobThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group_;
        private int threadId_ = 0;

        JobThreadFactory(String prefix) {
            this.group_ = new ThreadGroup(prefix);
            this.group_.setDaemon(true);
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread result = new Thread(this.group_, r, this.group_.getName() + "-thread-" + ++this.threadId_);
            result.setDaemon(true);
            return result;
        }
    }

    private static class ThisJobMonitor
    implements JobMonitor,
    Runnable {
        private final Runnable job_;
        private int runsNo_;
        private Throwable exception_ = null;

        ThisJobMonitor(Runnable job, int noInstances) {
            this.job_ = job;
            if (noInstances <= 0) {
                throw new IllegalArgumentException("number of instances should be positive: " + noInstances);
            }
            this.runsNo_ = noInstances;
        }

        synchronized void setException(Throwable exception) {
            this.exception_ = exception;
            this.notifyAll();
        }

        @Override
        public synchronized void waitDone() throws InterruptedException {
            while (this.runsNo_ != 0 && this.exception_ == null) {
                this.wait();
            }
            if (this.exception_ != null) {
                throw new ComputationRuntimeException(this.exception_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.job_.run();
            }
            catch (Throwable e) {
                this.setException(e);
            }
            ThisJobMonitor thisJobMonitor = this;
            synchronized (thisJobMonitor) {
                if (--this.runsNo_ == 0) {
                    this.notifyAll();
                }
            }
        }
    }
}

