/*
 * Decompiled with CFR 0.152.
 */
package openllet.core;

import java.util.logging.Logger;
import openllet.core.KnowledgeBase;
import openllet.core.utils.FileUtils;
import openllet.shared.tools.Log;
import openllet.shared.tools.Logging;

public abstract class KBLoader
implements Logging {
    private static final Logger _logger = Log.getLogger(KBLoader.class);
    protected volatile String _inputFormat;

    public Logger getLogger() {
        return _logger;
    }

    public abstract void clear();

    public KnowledgeBase createKB(String ... fileNameList) {
        this.clear();
        this.parse(fileNameList);
        this.load();
        return this.getKB();
    }

    public abstract KnowledgeBase getKB();

    public abstract void load();

    public void parse(String ... fileNames) {
        _logger.fine(() -> "Parsing (" + fileNames.length + ") files");
        for (String fileName : fileNames) {
            String fileURI = FileUtils.getFileURI(fileName);
            this.parseFile(fileURI);
        }
        _logger.info("Parsing done.");
    }

    public abstract void setIgnoreImports(boolean var1);

    protected abstract void parseFile(String var1);

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

