/*
 * Decompiled with CFR 0.152.
 */
package openllet.core;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.DependencySet;
import openllet.core.KnowledgeBase;
import openllet.core.OpenlletOptions;
import openllet.core.PropertyType;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.ABoxImpl;
import openllet.core.boxes.abox.Edge;
import openllet.core.boxes.abox.Individual;
import openllet.core.boxes.abox.IndividualIterator;
import openllet.core.boxes.abox.Literal;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.rbox.RBox;
import openllet.core.boxes.rbox.RBoxImpl;
import openllet.core.boxes.rbox.Role;
import openllet.core.boxes.tbox.TBox;
import openllet.core.boxes.tbox.TBoxFactory;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.exceptions.UnrecognizedDatatypeException;
import openllet.core.exceptions.InconsistentOntologyException;
import openllet.core.exceptions.UnsupportedFeatureException;
import openllet.core.expressivity.Expressivity;
import openllet.core.expressivity.ExpressivityChecker;
import openllet.core.knowledge.Base;
import openllet.core.knowledge.DatatypeVisitor;
import openllet.core.knowledge.FullyDefinedClassVisitor;
import openllet.core.rules.ContinuousRulesStrategy;
import openllet.core.rules.UsableRuleFilter;
import openllet.core.rules.model.AtomDObject;
import openllet.core.rules.model.AtomDVariable;
import openllet.core.rules.model.AtomIObject;
import openllet.core.rules.model.AtomIVariable;
import openllet.core.rules.model.AtomVariable;
import openllet.core.rules.model.ClassAtom;
import openllet.core.rules.model.DatavaluedPropertyAtom;
import openllet.core.rules.model.IndividualPropertyAtom;
import openllet.core.rules.model.Rule;
import openllet.core.rules.model.RuleAtom;
import openllet.core.rules.model.RuleAtomImpl;
import openllet.core.rules.model.SameIndividualAtom;
import openllet.core.tableau.branch.Branch;
import openllet.core.tableau.completion.CompletionStrategy;
import openllet.core.tableau.completion.EmptySRIQStrategy;
import openllet.core.tableau.completion.SROIQStrategy;
import openllet.core.tableau.completion.incremental.DependencyIndex;
import openllet.core.tableau.completion.incremental.IncrementalRestore;
import openllet.core.taxonomy.Taxonomy;
import openllet.core.taxonomy.TaxonomyBuilder;
import openllet.core.taxonomy.TaxonomyNode;
import openllet.core.taxonomy.printer.ClassTreePrinter;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.AnnotationClasses;
import openllet.core.utils.Bool;
import openllet.core.utils.MultiMapUtils;
import openllet.core.utils.MultiValueMap;
import openllet.core.utils.SetUtils;
import openllet.core.utils.SizeEstimate;
import openllet.core.utils.TermFactory;
import openllet.core.utils.Timer;
import openllet.core.utils.Timers;
import openllet.core.utils.progress.ProgressMonitor;
import openllet.shared.tools.Log;

public class KnowledgeBaseImpl
implements KnowledgeBase {
    public static final Logger _logger = Log.getLogger(KnowledgeBaseImpl.class);
    public final Timers _timers;
    protected final MultiValueMap<AssertionType, ATermAppl> _aboxAssertions = new MultiValueMap();
    private final Set<ATermAppl> _individuals = SetUtils.create();
    private final Map<ATermAppl, Map<ATermAppl, Set<ATermAppl>>> _annotations;
    private final Map<ATermAppl, Set<ATermAppl>> _instances = new ConcurrentHashMap<ATermAppl, Set<ATermAppl>>();
    private final FullyDefinedClassVisitor _fullyDefinedVisitor = new FullyDefinedClassVisitor(){

        @Override
        public boolean isProperty(ATerm p) {
            return KnowledgeBaseImpl.this.isProperty(p);
        }

        @Override
        public boolean isDatatype(ATermAppl p) {
            return KnowledgeBaseImpl.this.isDatatype(p);
        }

        @Override
        public TBox getTBox() {
            return KnowledgeBaseImpl.this._tbox;
        }

        @Override
        public Set<ATermAppl> getIndividuals() {
            return KnowledgeBaseImpl.this._individuals;
        }
    };
    private final DatatypeVisitor _datatypeVisitor = new DatatypeVisitor(){

        @Override
        public ABox getABox() {
            return KnowledgeBaseImpl.this._abox;
        }

        @Override
        public TBox getTBox() {
            return KnowledgeBaseImpl.this._tbox;
        }

        @Override
        public RBox getRBox() {
            return KnowledgeBaseImpl.this._rbox;
        }

        @Override
        public Timers getTimers() {
            return KnowledgeBaseImpl.this._timers;
        }
    };
    protected volatile ABox _abox;
    protected volatile TBox _tbox;
    protected volatile RBox _rbox;
    protected volatile Optional<TaxonomyBuilder> _builder = Optional.empty();
    protected volatile EnumSet<KnowledgeBase.ChangeType> _changes;
    protected volatile boolean _canUseIncConsistency = false;
    protected volatile EnumSet<ReasoningState> _state = EnumSet.noneOf(ReasoningState.class);
    private volatile boolean _consistent = false;
    private volatile boolean _explainOnlyInconsistency = false;
    private volatile ProgressMonitor _builderProgressMonitor;
    private volatile SizeEstimate _estimate;
    private volatile ExpressivityChecker _expChecker;
    private final Map<Rule, Rule> _rules = new HashMap<Rule, Rule>();
    private final Set<ATermAppl> _deletedAssertions = SetUtils.create();
    private final Set<ATermAppl> _syntacticAssertions = SetUtils.create();
    private volatile DependencyIndex _dependencyIndex;

    @Override
    public Map<ATermAppl, Map<ATermAppl, Set<ATermAppl>>> getAnnotations() {
        return this._annotations;
    }

    @Override
    public Map<ATermAppl, Set<ATermAppl>> getInstances() {
        return this._instances;
    }

    @Override
    public ProgressMonitor getBuilderProgressMonitor() {
        return this._builderProgressMonitor;
    }

    @Override
    public void setBuilderProgressMonitor(ProgressMonitor builderProgressMonitor) {
        this._builderProgressMonitor = builderProgressMonitor;
    }

    @Override
    public FullyDefinedClassVisitor getFullyDefinedVisitor() {
        return this._fullyDefinedVisitor;
    }

    @Override
    public DatatypeVisitor getDatatypeVisitor() {
        return this._datatypeVisitor;
    }

    @Override
    public Optional<TaxonomyBuilder> getOptTaxonomyBuilder() {
        return this._builder;
    }

    @Override
    public void setOptTaxonomyBuilder(Optional<TaxonomyBuilder> builder) {
        this._builder = builder;
    }

    @Override
    public EnumSet<KnowledgeBase.ChangeType> getChanges() {
        return this._changes;
    }

    public void setChanges(EnumSet<KnowledgeBase.ChangeType> changes) {
        this._changes = changes;
    }

    @Override
    public ExpressivityChecker getExpChecker() {
        return this._expChecker;
    }

    public void setExpChecker(ExpressivityChecker expChecker) {
        this._expChecker = expChecker;
    }

    public KnowledgeBaseImpl() {
        this.clear();
        this._timers = new Timers();
        this._timers.createTimer("preprocessing");
        this._timers.createTimer("consistency");
        this._timers.createTimer("complete");
        this._state = EnumSet.noneOf(ReasoningState.class);
        if (OpenlletOptions.USE_INCREMENTAL_DELETION) {
            this._dependencyIndex = new DependencyIndex(this);
        }
        this._annotations = new ConcurrentHashMap<ATermAppl, Map<ATermAppl, Set<ATermAppl>>>();
    }

    protected KnowledgeBaseImpl(KnowledgeBaseImpl kb, boolean emptyABox) {
        this._timers = kb._timers;
        this._tbox = kb._tbox;
        this._rbox = kb._rbox;
        this._rules.clear();
        this._rules.putAll(kb._rules);
        this._annotations = kb._annotations;
        this._expChecker = new ExpressivityChecker(this, kb.getExpressivity());
        this._changes = kb._changes.clone();
        if (OpenlletOptions.USE_INCREMENTAL_DELETION) {
            this._dependencyIndex = new DependencyIndex(this);
        }
        if (emptyABox) {
            this._abox = new ABoxImpl(this);
            this._instances.clear();
            for (ATermAppl nominal : kb.getExpressivity().getNominals()) {
                this.addIndividual(nominal);
            }
        } else {
            this._abox = kb._abox.copy(this);
            if (OpenlletOptions.KEEP_ABOX_ASSERTIONS) {
                for (AssertionType assertionType : AssertionType.values()) {
                    Set assertions = (Set)kb._aboxAssertions.get((Object)assertionType);
                    if (assertions.isEmpty()) continue;
                    this._aboxAssertions.put(assertionType, SetUtils.create(assertions));
                }
            }
            this._individuals.addAll(kb._individuals);
            this._instances.clear();
            this._instances.putAll(kb._instances);
            this._deletedAssertions.addAll(kb.getDeletedAssertions());
            this._syntacticAssertions.addAll(kb._syntacticAssertions);
            if (OpenlletOptions.USE_INCREMENTAL_CONSISTENCY && OpenlletOptions.USE_INCREMENTAL_DELETION) {
                this._dependencyIndex = new DependencyIndex(this, kb._dependencyIndex);
            }
        }
        if (kb.isConsistencyDone()) {
            this.prepare();
            this._state = EnumSet.of(ReasoningState.CONSISTENCY);
            this._consistent = kb._consistent;
            this._abox.setComplete(true);
            this._estimate = new SizeEstimate(this);
        } else {
            this._state = EnumSet.noneOf(ReasoningState.class);
        }
    }

    @Override
    public KnowledgeBase getKnowledgeBase() {
        return this;
    }

    @Override
    public Timers getTimers() {
        return this._timers;
    }

    @Override
    public ABox getABox() {
        return this._abox;
    }

    @Override
    public TBox getTBox() {
        return this._tbox;
    }

    @Override
    public RBox getRBox() {
        return this._rbox;
    }

    @Override
    public TaxonomyBuilder getBuilder() {
        return this.getTaxonomyBuilder();
    }

    public Logger getLogger() {
        return _logger;
    }

    @Override
    public Expressivity getExpressivity() {
        return this.getExpressivityChecker().getExpressivity();
    }

    @Override
    public ExpressivityChecker getExpressivityChecker() {
        if (this.canUseIncConsistency()) {
            return this._expChecker;
        }
        this.prepare();
        return this._expChecker;
    }

    @Override
    public void clear() {
        if (this._abox == null) {
            this._abox = new ABoxImpl(this);
        } else {
            boolean doExplanation = this._abox.doExplanation();
            boolean keepLastCompletion = this._abox.isKeepLastCompletion();
            this._abox = new ABoxImpl(this);
            this._abox.setDoExplanation(doExplanation);
            this._abox.setKeepLastCompletion(keepLastCompletion);
        }
        this._tbox = TBoxFactory.createTBox(this);
        this._rbox = new RBoxImpl();
        this._rules.clear();
        this._expChecker = new ExpressivityChecker(this);
        this._individuals.clear();
        this._aboxAssertions.clear();
        this._instances.clear();
        this._builder = Optional.empty();
        this._state.clear();
        this._changes = EnumSet.of(KnowledgeBase.ChangeType.ABOX_ADD, KnowledgeBase.ChangeType.TBOX_ADD, KnowledgeBase.ChangeType.RBOX_ADD);
    }

    @Override
    public void clearABox() {
        this._aboxAssertions.clear();
        this._annotations.clear();
        if (OpenlletOptions.USE_INCREMENTAL_DELETION) {
            this._deletedAssertions.clear();
            this._syntacticAssertions.clear();
            this._dependencyIndex = new DependencyIndex(this);
        }
        this._abox = new ABoxImpl(this, true);
        this._individuals.clear();
        this._changes = EnumSet.of(KnowledgeBase.ChangeType.ABOX_DEL);
        this.prepare();
        for (ATermAppl nominal : this.getExpressivity().getNominals()) {
            this.addIndividual(nominal);
        }
    }

    @Override
    public KnowledgeBase copy(boolean emptyABox) {
        return new KnowledgeBaseImpl(this, emptyABox);
    }

    @Override
    public void addClass(ATermAppl c) {
        if (null == c || c.equals(ATermUtils.TOP) || ATermUtils.isComplexClass((ATerm)c)) {
            return;
        }
        boolean added = this._tbox.addClass(c);
        if (added) {
            this._changes.add(KnowledgeBase.ChangeType.TBOX_ADD);
            _logger.finer(() -> "class " + c);
        }
    }

    @Override
    public void addSubClass(ATermAppl sub, ATermAppl sup) {
        if (null == sub || null == sup || sub.equals(sup)) {
            return;
        }
        this._changes.add(KnowledgeBase.ChangeType.TBOX_ADD);
        this._tbox.addAxiom(ATermUtils.makeSub((ATerm)sub, (ATerm)sup));
        _logger.finer(() -> "sub-class " + sub + " " + sup);
    }

    @Override
    public void addEquivalentClass(ATermAppl c1, ATermAppl c2) {
        if (null == c1 || null == c2 || c1.equals(c2)) {
            return;
        }
        this._changes.add(KnowledgeBase.ChangeType.TBOX_ADD);
        this._tbox.addAxiom(ATermUtils.makeEqClasses((ATerm)c1, (ATerm)c2));
        _logger.finer(() -> "eq-class " + c1 + " " + c2);
    }

    @Override
    public void addKey(ATermAppl c, Set<ATermAppl> properties) {
        if (null == c || null == properties) {
            return;
        }
        int varId = 0;
        ArrayList<SameIndividualAtom> head = new ArrayList<SameIndividualAtom>();
        ArrayList<RuleAtomImpl> body = new ArrayList<RuleAtomImpl>();
        AtomIVariable x = new AtomIVariable("x");
        AtomIVariable y = new AtomIVariable("y");
        head.add(new SameIndividualAtom(x, y));
        for (ATermAppl property : properties) {
            AtomVariable z;
            if (this.isObjectProperty((ATerm)property)) {
                z = new AtomIVariable("z" + varId);
                body.add(new IndividualPropertyAtom(property, x, (AtomIObject)((Object)z)));
                body.add(new IndividualPropertyAtom(property, y, (AtomIObject)((Object)z)));
            } else if (this.isDatatypeProperty((ATerm)property)) {
                z = new AtomDVariable("z" + varId);
                body.add(new DatavaluedPropertyAtom(property, x, (AtomDObject)((Object)z)));
                body.add(new DatavaluedPropertyAtom(property, y, (AtomDObject)((Object)z)));
            }
            ++varId;
        }
        body.add(new ClassAtom(c, x));
        body.add(new ClassAtom(c, y));
        this.addRule(new Rule(head, body));
    }

    @Override
    public void addDisjointClasses(ATermList classes) {
        if (null == classes) {
            return;
        }
        this._changes.add(KnowledgeBase.ChangeType.TBOX_ADD);
        this._tbox.addAxiom(ATermUtils.makeDisjoints(classes));
        _logger.finer(() -> "disjoints " + classes);
    }

    @Override
    public void addDisjointClasses(List<ATermAppl> classes) {
        if (null == classes) {
            return;
        }
        this.addDisjointClasses(ATermUtils.toSet(classes));
    }

    @Override
    public void addDisjointClass(ATermAppl c1, ATermAppl c2) {
        if (null == c1 || null == c2) {
            return;
        }
        this._changes.add(KnowledgeBase.ChangeType.TBOX_ADD);
        this._tbox.addAxiom(ATermUtils.makeDisjoint((ATerm)c1, (ATerm)c2));
        _logger.finer(() -> "disjoint " + c1 + " " + c2);
    }

    @Override
    public void addComplementClass(ATermAppl c1, ATermAppl c2) {
        if (null == c1 || null == c2) {
            return;
        }
        this._changes.add(KnowledgeBase.ChangeType.TBOX_ADD);
        ATermAppl notC2 = ATermUtils.makeNot((ATerm)c2);
        if (c1.equals(notC2)) {
            return;
        }
        this._tbox.addAxiom(ATermUtils.makeEqClasses((ATerm)c1, (ATerm)notC2));
        _logger.finer(() -> "complement " + c1 + " " + c2);
    }

    @Override
    public Individual addIndividual(ATermAppl i) {
        if (null == i) {
            return null;
        }
        Node node = this._abox.getNode((ATerm)i);
        if (node != null) {
            if (node instanceof Literal) {
                throw new UnsupportedFeatureException("Trying to use a literal as an _individual: " + ATermUtils.toString(i));
            }
            return (Individual)node;
        }
        if (ATermUtils.isLiteral(i)) {
            throw new UnsupportedFeatureException("Trying to use a literal as an _individual: " + ATermUtils.toString(i));
        }
        int remember = this._abox.getBranchIndex();
        this._abox.setBranchIndex(-1);
        this._abox.setSyntacticUpdate(true);
        Individual ind = this._abox.addIndividual(i, DependencySet.INDEPENDENT);
        this._individuals.add(i);
        _logger.finer(() -> "individual " + i);
        this._abox.setSyntacticUpdate(false);
        if (!OpenlletOptions.USE_PSEUDO_NOMINALS) {
            ATermAppl nominal = ATermUtils.makeValue((ATerm)i);
            this._abox.addType(i, nominal, DependencySet.INDEPENDENT);
        }
        this._changes.add(KnowledgeBase.ChangeType.ABOX_ADD);
        if (this.canUseIncConsistency()) {
            this._abox.setSyntacticUpdate(true);
            for (int j = 0; j < this._abox.getBranches().size(); ++j) {
                Branch branch = this._abox.getBranches().get(j);
                branch.setNodeCount(branch.getNodeCount() + 1);
            }
            this._abox.getIncrementalChangeTracker().addUpdatedIndividual(this._abox.getIndividual((ATerm)i));
            this._abox.getIncrementalChangeTracker().addNewIndividual(this._abox.getIndividual((ATerm)i));
            this._abox.setSyntacticUpdate(false);
        }
        this._abox.setBranchIndex(remember);
        return ind;
    }

    @Override
    public void addType(ATermAppl i, ATermAppl c) {
        DependencySet ds;
        if (null == i || null == c) {
            return;
        }
        if (AnnotationClasses.contains(c)) {
            return;
        }
        ATermAppl typeAxiom = ATermUtils.makeTypeAtom(i, c);
        DependencySet dependencySet = ds = OpenlletOptions.USE_TRACING ? new DependencySet(typeAxiom) : DependencySet.INDEPENDENT;
        if (OpenlletOptions.USE_INCREMENTAL_DELETION) {
            this._syntacticAssertions.add(typeAxiom);
            this._dependencyIndex.addTypeDependency(i, c, ds);
        }
        if (OpenlletOptions.KEEP_ABOX_ASSERTIONS) {
            this._aboxAssertions.add(AssertionType.TYPE, typeAxiom);
        }
        this.addType(i, c, ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addType(ATermAppl i, ATermAppl c, DependencySet ds) {
        if (null == i || null == c || null == ds) {
            return;
        }
        this._changes.add(KnowledgeBase.ChangeType.ABOX_ADD);
        if (this.canUseIncConsistency()) {
            this._abox.getIncrementalChangeTracker().addUpdatedIndividual(this._abox.getIndividual((ATerm)i));
        }
        ABox aBox = this._abox;
        synchronized (aBox) {
            this._abox.setSyntacticUpdate(true);
            this._abox.addType(i, c, ds);
            this._abox.setSyntacticUpdate(false);
        }
        if (this.canUseIncConsistency()) {
            this.updateExpressivity(i, c);
        }
        _logger.finer(() -> "type " + i + " " + c);
    }

    @Override
    public void addSame(ATermAppl i1, ATermAppl i2) {
        if (null == i1 || null == i2) {
            return;
        }
        this._changes.add(KnowledgeBase.ChangeType.ABOX_ADD);
        if (this.canUseIncConsistency()) {
            this._abox.getIncrementalChangeTracker().addUpdatedIndividual(this._abox.getIndividual((ATerm)i1));
            this._abox.getIncrementalChangeTracker().addUpdatedIndividual(this._abox.getIndividual((ATerm)i2));
            this._abox.addSame(i1, i2);
        }
        this._abox.addSame(i1, i2);
        _logger.finer(() -> "same " + i1 + " " + i2);
    }

    @Override
    public void addAllDifferent(ATermList list) {
        if (null == list) {
            return;
        }
        this._changes.add(KnowledgeBase.ChangeType.ABOX_ADD);
        if (this.canUseIncConsistency()) {
            ATermList outer = list;
            while (!outer.isEmpty()) {
                ATermList inner = outer.getNext();
                while (!inner.isEmpty()) {
                    this._abox.getIncrementalChangeTracker().addUpdatedIndividual(this._abox.getIndividual((ATerm)outer.getFirst()));
                    this._abox.getIncrementalChangeTracker().addUpdatedIndividual(this._abox.getIndividual((ATerm)inner.getFirst()));
                    inner = inner.getNext();
                }
                outer = outer.getNext();
            }
            int branch = this._abox.getBranchIndex();
            this._abox.setBranchIndex(0);
            this._abox.addAllDifferent(list);
            this._abox.setBranchIndex(branch);
        }
        this._abox.addAllDifferent(list);
        _logger.finer(() -> "all diff " + list);
    }

    @Override
    public void addDifferent(ATermAppl i1, ATermAppl i2) {
        if (null == i1 || null == i2) {
            return;
        }
        this._changes.add(KnowledgeBase.ChangeType.ABOX_ADD);
        if (this.canUseIncConsistency()) {
            this._abox.getIncrementalChangeTracker().addUpdatedIndividual(this._abox.getIndividual((ATerm)i1));
            this._abox.getIncrementalChangeTracker().addUpdatedIndividual(this._abox.getIndividual((ATerm)i2));
            int branch = this._abox.getBranchIndex();
            this._abox.setBranchIndex(0);
            this._abox.addDifferent(i1, i2);
            this._abox.setBranchIndex(branch);
        }
        this._abox.addDifferent(i1, i2);
        _logger.finer(() -> "diff " + i1 + " " + i2);
    }

    @Deprecated
    public void addObjectPropertyValue(ATermAppl p, ATermAppl s, ATermAppl o) {
        this.addPropertyValue(p, s, o);
    }

    @Override
    public boolean addPropertyValue(ATermAppl p, ATermAppl s, ATermAppl o) {
        DependencySet ds;
        if (null == p || null == s || null == o) {
            return false;
        }
        Individual subj = this._abox.getIndividual((ATerm)s);
        Role role = this.getRole((ATerm)p);
        Node obj = null;
        if (subj == null) {
            _logger.warning(s + " is not a known individual!");
            return false;
        }
        if (role == null) {
            _logger.warning(p + " is not a known property!");
            return false;
        }
        if (!role.isObjectRole() && !role.isDatatypeRole()) {
            return false;
        }
        ATermAppl propAxiom = ATermUtils.makePropAtom(p, s, o);
        DependencySet dependencySet = ds = OpenlletOptions.USE_TRACING ? new DependencySet(propAxiom) : DependencySet.INDEPENDENT;
        if (role.isObjectRole()) {
            obj = this._abox.getIndividual((ATerm)o);
            if (obj == null) {
                if (ATermUtils.isLiteral(o)) {
                    _logger.warning("Ignoring literal value " + o + " for object property " + p);
                    return false;
                }
                _logger.warning(o + " is not a known individual!");
                return false;
            }
            if (OpenlletOptions.KEEP_ABOX_ASSERTIONS) {
                this._aboxAssertions.add(AssertionType.OBJ_ROLE, propAxiom);
            }
        } else if (role.isDatatypeRole()) {
            if (!ATermUtils.isLiteral(o)) {
                _logger.warning("Ignoring non-literal value " + o + " for _data property " + p);
                return false;
            }
            obj = this._abox.addLiteral(o, ds);
            if (OpenlletOptions.KEEP_ABOX_ASSERTIONS) {
                this._aboxAssertions.add(AssertionType.DATA_ROLE, propAxiom);
            }
        }
        this._changes.add(KnowledgeBase.ChangeType.ABOX_ADD);
        if (obj != null && !this.canUseIncConsistency()) {
            Edge edge = this._abox.addEdge(p, s, obj.getName(), ds);
            if (edge == null) {
                this._abox.reset();
                edge = this._abox.addEdge(p, s, obj.getName(), ds);
                assert (edge != null);
            }
            if (OpenlletOptions.USE_INCREMENTAL_DELETION) {
                this._syntacticAssertions.add(propAxiom);
                this._dependencyIndex.addEdgeDependency(edge, edge.getDepends());
            }
        } else if (this.canUseIncConsistency()) {
            Individual subj2;
            this._abox.getIncrementalChangeTracker().addUpdatedIndividual(this._abox.getIndividual((ATerm)s));
            if (role.isObjectRole()) {
                this._abox.getIncrementalChangeTracker().addUpdatedIndividual(this._abox.getIndividual((ATerm)o));
                obj = this._abox.getIndividual((ATerm)o);
                if (obj.isPruned() || obj.isMerged()) {
                    obj = obj.getSame();
                }
            }
            if ((subj2 = this._abox.getIndividual((ATerm)s)).isPruned() || subj2.isMerged()) {
                subj2 = subj2.getSame();
            }
            ds = OpenlletOptions.USE_TRACING ? new DependencySet(ATermUtils.makePropAtom(p, s, o)) : DependencySet.INDEPENDENT;
            int branch = this._abox.getBranchIndex();
            this._abox.setBranchIndex(-1);
            Edge newEdge = subj2.addEdge(role, obj, ds);
            this._abox.setBranchIndex(branch);
            if (newEdge != null) {
                this._abox.getIncrementalChangeTracker().addNewEdge(newEdge);
            }
        }
        _logger.finer(() -> "prop-value " + s + " " + p + " " + o);
        return true;
    }

    @Override
    public boolean addNegatedPropertyValue(ATermAppl p, ATermAppl s, ATermAppl o) {
        DependencySet ds;
        if (null == p || null == s || null == o) {
            return false;
        }
        this._changes.add(KnowledgeBase.ChangeType.ABOX_ADD);
        Individual subj = this._abox.getIndividual((ATerm)s);
        Role role = this.getRole((ATerm)p);
        if (subj == null) {
            _logger.warning(s + " is not a known individual!");
            return false;
        }
        if (role == null) {
            _logger.warning(p + " is not a known property!");
            return false;
        }
        ATermAppl propAxiom = ATermUtils.makeNot((ATerm)ATermUtils.makePropAtom(p, s, o));
        DependencySet dependencySet = ds = OpenlletOptions.USE_TRACING ? new DependencySet(propAxiom) : DependencySet.INDEPENDENT;
        if (role.isObjectRole()) {
            if (this._abox.getIndividual((ATerm)o) == null) {
                if (ATermUtils.isLiteral(o)) {
                    _logger.warning("Ignoring literal value " + o + " for object property " + p);
                    return false;
                }
                _logger.warning(o + " is not a known individual!");
                return false;
            }
        } else if (role.isDatatypeRole()) {
            this._abox.addLiteral(o, ds);
        }
        ATermAppl C = ATermUtils.makeNot((ATerm)ATermUtils.makeHasValue((ATerm)p, (ATerm)o));
        this.addType(s, C, ds);
        _logger.finer(() -> "not-prop-value " + s + " " + p + " " + o);
        return true;
    }

    @Override
    public void addProperty(ATermAppl p) {
        this._changes.add(KnowledgeBase.ChangeType.RBOX_ADD);
        this._rbox.addRole(p);
        _logger.finer(() -> "prop " + p);
    }

    @Override
    public boolean addObjectProperty(ATerm p) {
        if (null == p) {
            return false;
        }
        boolean exists = this.getPropertyType(p) == PropertyType.OBJECT;
        Role role = this._rbox.addObjectRole((ATermAppl)p);
        if (!exists) {
            this._changes.add(KnowledgeBase.ChangeType.RBOX_ADD);
            _logger.finer(() -> "object-prop " + p);
        }
        return role != null;
    }

    @Override
    public boolean addDatatypeProperty(ATerm p) {
        if (null == p) {
            return false;
        }
        boolean exists = this.getPropertyType(p) == PropertyType.DATATYPE;
        Role role = this._rbox.addDatatypeRole((ATermAppl)p);
        if (!exists) {
            this._changes.add(KnowledgeBase.ChangeType.RBOX_ADD);
            _logger.finer(() -> "data-prop " + p);
        }
        return role != null;
    }

    @Deprecated
    public void addOntologyProperty(ATermAppl p) {
        this.addAnnotationProperty((ATerm)p);
    }

    @Override
    public boolean addAnnotationProperty(ATerm p) {
        if (null == p) {
            return false;
        }
        boolean exists = this.getPropertyType(p) == PropertyType.ANNOTATION;
        Role role = this._rbox.addAnnotationRole((ATermAppl)p);
        if (!exists) {
            this._changes.add(KnowledgeBase.ChangeType.RBOX_ADD);
            _logger.finer(() -> "annotation-prop " + p);
        }
        return role != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAnnotation(ATermAppl s, ATermAppl p, ATermAppl o) {
        if (null == p || null == s || null == o || !OpenlletOptions.USE_ANNOTATION_SUPPORT || !this.isAnnotationProperty((ATerm)p)) {
            return false;
        }
        Map<ATermAppl, Map<ATermAppl, Set<ATermAppl>>> map = this._annotations;
        synchronized (map) {
            Set<ATermAppl> oidx;
            Map<ATermAppl, Set<ATermAppl>> pidx = this._annotations.get(s);
            if (pidx == null) {
                pidx = new HashMap<ATermAppl, Set<ATermAppl>>();
            }
            if ((oidx = pidx.get(p)) == null) {
                oidx = new HashSet<ATermAppl>();
            }
            oidx.add(o);
            pidx.put(p, oidx);
            this._annotations.put(s, pidx);
        }
        _logger.finer(() -> "annotation " + s + " " + p + " " + o);
        return true;
    }

    @Override
    public boolean isAnnotation(ATermAppl s, ATermAppl p, ATermAppl o) {
        Set oidx = this.getAnnotations(s, p);
        if (oidx == null) {
            return false;
        }
        return oidx.contains(o);
    }

    @Override
    public void addDomain(ATerm p, ATermAppl c) {
        if (null == p || null == c) {
            return;
        }
        this._changes.add(KnowledgeBase.ChangeType.RBOX_ADD);
        this._rbox.addDomain(p, c);
        _logger.finer(() -> "domain " + p + " " + c);
    }

    @Override
    public void addDomain(ATerm p, ATermAppl c, Set<ATermAppl> explain) {
        this._changes.add(KnowledgeBase.ChangeType.RBOX_ADD);
        this._rbox.addDomain(p, c, explain);
        _logger.finer(() -> "domain " + p + " " + c + " " + explain);
    }

    @Override
    public void addRange(ATerm p, ATermAppl c) {
        this._changes.add(KnowledgeBase.ChangeType.RBOX_ADD);
        this._rbox.addRange(p, c);
        _logger.finer(() -> "range " + p + " " + c);
    }

    @Override
    public void addRange(ATerm p, ATermAppl c, Set<ATermAppl> explain) {
        if (null == p || null == c || null == explain) {
            return;
        }
        this._changes.add(KnowledgeBase.ChangeType.RBOX_ADD);
        this._rbox.addRange(p, c, explain);
        _logger.finer(() -> "range " + p + " " + c + " " + explain);
    }

    @Override
    public void addDatatype(ATermAppl p) {
        if (null == p) {
            return;
        }
        this.getDatatypeReasoner().declare(p);
    }

    @Override
    public boolean addDatatypeDefinition(ATermAppl name, ATermAppl datarange) {
        if (null == name || null == datarange) {
            return false;
        }
        return this.getDatatypeReasoner().define(name, datarange);
    }

    @Override
    public boolean removeDomain(ATerm p, ATermAppl c) {
        if (null == p || null == c) {
            return false;
        }
        Role role = this.getRole(p);
        if (role == null) {
            Base.handleUndefinedEntity(p + " is not a property!");
            return false;
        }
        if (!this.isClass((ATerm)c)) {
            Base.handleUndefinedEntity(c + " is not a valid class expression");
            return false;
        }
        boolean removed = this.getRBox().removeDomain(p, c);
        if (removed) {
            this._changes.add(KnowledgeBase.ChangeType.RBOX_DEL);
        }
        _logger.finer(() -> "Remove domain " + p + " " + c);
        return removed;
    }

    @Override
    public boolean removePropertyValue(ATermAppl p, ATermAppl i1, ATermAppl i2) {
        ATermAppl ind2;
        if (null == p || null == i1 || null == i2) {
            return false;
        }
        ATermAppl ind1 = i1;
        if (ATermUtils.isLiteral(i2)) {
            try {
                ind2 = this._abox.getDatatypeReasoner().getCanonicalRepresentation(i2);
            }
            catch (InvalidLiteralException e) {
                _logger.warning(String.format("Unable to remove property value (%s,%s,%s) due to invalid literal: %s", p, i1, i2, e.getMessage()));
                return false;
            }
            catch (UnrecognizedDatatypeException e) {
                _logger.warning(String.format("Unable to remove property value (%s,%s,%s) due to unrecognized datatype for literal: %s", p, i1, i2, e.getMessage()));
                return false;
            }
        } else {
            ind2 = i2;
        }
        Individual subj = this._abox.getIndividual((ATerm)ind1);
        Node obj = this._abox.getNode((ATerm)ind2);
        Role role = this.getRole((ATerm)p);
        if (subj == null) {
            if (OpenlletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                throw new UnsupportedFeatureException(ind1 + " is not an individual!");
            }
            return false;
        }
        if (obj == null) {
            Base.handleUndefinedEntity(ind2 + " is not an individual!");
            return false;
        }
        if (role == null) {
            Base.handleUndefinedEntity(p + " is not a property!");
            return false;
        }
        _logger.finer(() -> "Remove ObjectPropertyValue " + ind1 + " " + p + " " + ind2);
        Edge edge = subj.getOutEdges().getExactEdge(subj, role, obj);
        if (edge == null && obj.isMerged()) {
            edge = obj.getInEdges().getExactEdge(subj, role, obj);
        }
        if (edge == null) {
            return false;
        }
        this._changes.add(KnowledgeBase.ChangeType.ABOX_DEL);
        if (!this.canUseIncConsistency()) {
            this._abox.reset();
            subj.removeEdge(edge);
            obj.removeInEdge(edge);
        } else {
            this.getDeletedAssertions().add(ATermUtils.makePropAtom(p, ind1, ind2));
            this._abox.getIncrementalChangeTracker().addUpdatedIndividual(subj);
            if (!role.isDatatypeRole()) {
                this._abox.getIncrementalChangeTracker().addUpdatedIndividual((Individual)obj);
            }
        }
        if (OpenlletOptions.KEEP_ABOX_ASSERTIONS) {
            ATermAppl propAxiom = ATermUtils.makePropAtom(p, ind1, ind2);
            if (ATermUtils.isLiteral(ind2)) {
                this._aboxAssertions.remove((Object)AssertionType.DATA_ROLE, propAxiom);
            } else {
                this._aboxAssertions.remove((Object)AssertionType.OBJ_ROLE, propAxiom);
            }
        }
        return true;
    }

    @Override
    public boolean removeRange(ATerm p, ATermAppl c) {
        if (null == p || null == c) {
            return false;
        }
        Role role = this.getRole(p);
        if (role == null) {
            Base.handleUndefinedEntity(p + " is not a property!");
            return false;
        }
        if (!this.isClass((ATerm)c) && !this.isDatatype(c)) {
            Base.handleUndefinedEntity(c + " is not a valid class expression or data range");
            return false;
        }
        boolean removed = this.getRBox().removeRange(p, c);
        if (removed) {
            this._changes.add(KnowledgeBase.ChangeType.RBOX_DEL);
        }
        _logger.finer(() -> "Remove range" + p + " " + c);
        return removed;
    }

    @Override
    public boolean removeType(ATermAppl ind, ATermAppl c) {
        if (null == ind || null == c) {
            return false;
        }
        Individual subj = this._abox.getIndividual((ATerm)ind);
        if (subj == null) {
            if (OpenlletOptions.SILENT_UNDEFINED_ENTITY_HANDLING) {
                return false;
            }
            throw new UnsupportedFeatureException(ind + " is not an individual!");
        }
        ATermAppl normC = ATermUtils.normalize(c);
        DependencySet ds = subj.getDepends((ATerm)normC);
        if (ds == null || !ds.isIndependent()) {
            return false;
        }
        boolean removed = true;
        if (!this.canUseIncConsistency() || !OpenlletOptions.USE_INCREMENTAL_DELETION) {
            this._abox.reset();
            removed = subj.removeType(normC);
        } else {
            this.getDeletedAssertions().add(ATermUtils.makeTypeAtom(ind, c));
            this._abox.getIncrementalChangeTracker().addUpdatedIndividual(subj);
        }
        if (OpenlletOptions.KEEP_ABOX_ASSERTIONS) {
            ATermAppl typeAxiom = ATermUtils.makeTypeAtom(ind, c);
            this._aboxAssertions.remove((Object)AssertionType.TYPE, typeAxiom);
        }
        this._changes.add(KnowledgeBase.ChangeType.ABOX_DEL);
        _logger.finer(() -> "Remove Type " + ind + " " + c);
        return removed;
    }

    @Override
    public boolean removeAxiom(ATermAppl axiom) {
        if (null == axiom) {
            return false;
        }
        boolean removed = false;
        try {
            removed = this._tbox.removeAxiom(axiom);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "Removal failed for axiom " + axiom, e);
        }
        if (removed) {
            this._changes.add(KnowledgeBase.ChangeType.TBOX_DEL);
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer("Remove " + axiom + ": " + removed);
        }
        return removed;
    }

    @Override
    public void prepare() {
        boolean reuseTaxonomy;
        if (!this.isChanged()) {
            return;
        }
        boolean explain = this._abox.doExplanation();
        this._abox.setDoExplanation(true);
        Optional<Timer> timer = this._timers.startTimer("preprocessing");
        this._state.remove((Object)ReasoningState.CONSISTENCY);
        this._state.remove((Object)ReasoningState.REALIZE);
        boolean bl = reuseTaxonomy = this._state.contains((Object)ReasoningState.CLASSIFY) && !this.isTBoxChanged() && !this.isRBoxChanged() && (!this._expChecker.getExpressivity().hasNominal() || OpenlletOptions.USE_PSEUDO_NOMINALS);
        if (this.isRBoxChanged()) {
            this._timers.execute("rbox", x -> this._rbox.prepare());
        }
        if (this.isTBoxChanged()) {
            this._timers.execute("normalize", x -> this._tbox.prepare());
        }
        if (this.isRBoxChanged()) {
            this._rbox.propagateDomainRange();
        }
        this._canUseIncConsistency = this.canUseIncConsistency();
        if (this._abox.isComplete()) {
            if (this._changes.contains((Object)KnowledgeBase.ChangeType.TBOX_DEL) || this._changes.contains((Object)KnowledgeBase.ChangeType.RBOX_DEL) || !this._canUseIncConsistency && this._changes.contains((Object)KnowledgeBase.ChangeType.ABOX_DEL)) {
                this._abox.reset();
            } else if (this._changes.contains((Object)KnowledgeBase.ChangeType.TBOX_ADD) || this._changes.contains((Object)KnowledgeBase.ChangeType.RBOX_ADD)) {
                this._abox.resetQueue();
            } else if (this._canUseIncConsistency && this._changes.contains((Object)KnowledgeBase.ChangeType.ABOX_DEL)) {
                IncrementalRestore.restoreDependencies(this);
            }
        }
        this._changes.clear();
        this._instances.clear();
        this._estimate = new SizeEstimate(this);
        this._abox.setDoExplanation(explain);
        if (!this._canUseIncConsistency) {
            _logger.finer(() -> "Expressivity...");
            this._expChecker.prepare();
        }
        this._abox.clearCaches(!reuseTaxonomy);
        this._abox.getCache().setMaxSize(OpenlletOptions.MAX_ANONYMOUS_CACHE);
        if (!reuseTaxonomy) {
            this._state.remove((Object)ReasoningState.CLASSIFY);
            this._builder = Optional.empty();
        }
        timer.ifPresent(t -> t.stop());
        if (_logger.isLoggable(Level.FINE)) {
            StringBuffer info = new StringBuffer();
            info.append("Expressivity: " + this._expChecker.getExpressivity() + ", ");
            info.append("Classes: " + this.getClasses().size() + " ");
            info.append("Properties: " + this.getProperties().size() + " ");
            info.append("Individuals: " + this._individuals.size());
            _logger.fine(info.toString());
        }
    }

    public void updateExpressivity(ATermAppl i, ATermAppl c) {
        if (null == i || null == c) {
            return;
        }
        if (!this.isChanged() || this.isTBoxChanged() || this.isRBoxChanged()) {
            return;
        }
        this._expChecker.updateWithIndividual(i, c);
        this._estimate = new SizeEstimate(this);
    }

    public String getInfo() {
        this.prepare();
        StringBuffer buffer = new StringBuffer();
        buffer.append("Expressivity: " + this._expChecker.getExpressivity() + " ");
        buffer.append("Classes: " + this.getClasses().size() + " ");
        buffer.append("Properties: " + this.getProperties().size() + " ");
        buffer.append("Individuals: " + this._individuals.size() + " ");
        Expressivity expressivity = this._expChecker.getExpressivity();
        if (expressivity.hasNominal()) {
            buffer.append("Nominals: " + expressivity.getNominals().size() + " ");
        }
        return buffer.toString();
    }

    @Override
    public boolean isConsistencyDone() {
        return !this.isChanged() && this._state.contains((Object)ReasoningState.CONSISTENCY);
    }

    @Override
    public boolean isClassified() {
        return !this.isChanged() && this._state.contains((Object)ReasoningState.CLASSIFY);
    }

    @Override
    public boolean isRealized() {
        return !this.isChanged() && this._state.contains((Object)ReasoningState.REALIZE);
    }

    public boolean isChanged() {
        return !this._changes.isEmpty();
    }

    @Override
    public boolean isChanged(KnowledgeBase.ChangeType change) {
        return this._changes.contains((Object)change);
    }

    public boolean isTBoxChanged() {
        return this._changes.contains((Object)KnowledgeBase.ChangeType.TBOX_ADD) || this._changes.contains((Object)KnowledgeBase.ChangeType.TBOX_DEL);
    }

    public boolean isRBoxChanged() {
        return this._changes.contains((Object)KnowledgeBase.ChangeType.RBOX_ADD) || this._changes.contains((Object)KnowledgeBase.ChangeType.RBOX_DEL);
    }

    public boolean isABoxChanged() {
        return this._changes.contains((Object)KnowledgeBase.ChangeType.ABOX_ADD) || this._changes.contains((Object)KnowledgeBase.ChangeType.ABOX_DEL);
    }

    @Override
    public Set<ATermAppl> getUnsatisfiableClasses() {
        return this.getUnsatisfiableClasses(false);
    }

    @Override
    public Set<ATermAppl> getAllUnsatisfiableClasses() {
        return this.getUnsatisfiableClasses(true);
    }

    private Set<ATermAppl> getUnsatisfiableClasses(boolean includeBottom) {
        HashSet<ATermAppl> aUnsatClasses = new HashSet<ATermAppl>();
        if (this.isClassified()) {
            aUnsatClasses = includeBottom ? this.getAllEquivalentClasses(ATermUtils.BOTTOM) : this.getEquivalentClasses(ATermUtils.BOTTOM);
        } else {
            if (includeBottom) {
                aUnsatClasses.add(TermFactory.BOTTOM);
            }
            Set aClasses = this.getClasses();
            for (ATermAppl aClass : aClasses) {
                if (this.isSatisfiable(aClass)) continue;
                aUnsatClasses.add(aClass);
            }
        }
        return aUnsatClasses;
    }

    private void consistency() {
        if (this.isConsistencyDone()) {
            return;
        }
        this._abox.setInitialized(false);
        this.prepare();
        for (Map.Entry<Rule, Rule> normalizedRule : this._rules.entrySet()) {
            if (normalizedRule.getValue() != null) continue;
            Rule rule = normalizedRule.getKey();
            String msg = UsableRuleFilter.explainNotUsable(rule);
            _logger.warning("Ignoring rule " + rule + ": " + msg);
        }
        Optional<Timer> timer = this._timers.startTimer("consistency");
        boolean doExplanation = this._abox.doExplanation();
        if (OpenlletOptions.USE_TRACING && !this._explainOnlyInconsistency) {
            this._abox.setDoExplanation(true);
        }
        boolean bl = this._consistent = this._canUseIncConsistency ? this._abox.isIncConsistent() : this._abox.isConsistent();
        if (OpenlletOptions.USE_INCREMENTAL_CONSISTENCY) {
            this._abox.getIncrementalChangeTracker().clear();
        }
        if (OpenlletOptions.USE_INCREMENTAL_DELETION) {
            this.getDeletedAssertions().clear();
        }
        if (!this._consistent) {
            if (OpenlletOptions.USE_TRACING && this._explainOnlyInconsistency && !this._abox.doExplanation()) {
                this._abox.setDoExplanation(true);
                this._abox.reset();
                this._abox.isConsistent();
                this._abox.setDoExplanation(false);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Inconsistent ontology. Reason: " + this.getExplanation());
            }
            if (OpenlletOptions.USE_TRACING && _logger.isLoggable(Level.FINE)) {
                _logger.fine(this.renderExplanationSet());
            }
        }
        this._abox.setDoExplanation(doExplanation);
        this._state.add(ReasoningState.CONSISTENCY);
        timer.ifPresent(t -> t.stop());
        if (_logger.isLoggable(Level.FINE) && timer.isPresent()) {
            _logger.fine("Consistent: " + this._consistent + " (" + timer.get().getLast() + "ms)");
        }
        assert (this.isConsistencyDone()) : "Consistency flag not set";
    }

    private String renderExplanationSet() {
        StringBuilder msg = new StringBuilder("ExplanationSet: [");
        Set explanation = this.getExplanationSet();
        for (ATermAppl axiom : explanation) {
            msg.append(ATermUtils.toString(axiom));
            msg.append(",");
        }
        if (explanation.isEmpty()) {
            msg.append(']');
        } else {
            msg.setCharAt(msg.length() - 1, ']');
        }
        return msg.toString();
    }

    @Override
    public boolean isConsistent() {
        this.consistency();
        return this._consistent;
    }

    @Override
    public Taxonomy<ATermAppl> getToldTaxonomy() {
        return this.getTaxonomyBuilder().getToldTaxonomy();
    }

    @Override
    public Map<ATermAppl, Set<ATermAppl>> getToldDisjoints() {
        return this.getTaxonomyBuilder().getToldDisjoints();
    }

    @Override
    public void ensureConsistency() {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException("Cannot do reasoning with inconsistent ontologies!\nReason for inconsistency: " + this.getExplanation() + (String)(OpenlletOptions.USE_TRACING ? "\n" + this.renderExplanationSet() : ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void classify() {
        boolean isClassified;
        TaxonomyBuilder builder;
        this.ensureConsistency();
        if (this.isClassified()) {
            return;
        }
        _logger.fine("Classifying...");
        Optional<Timer> timer = this._timers.startTimer("classify");
        TaxonomyBuilder taxonomyBuilder = builder = this.getTaxonomyBuilder();
        synchronized (taxonomyBuilder) {
            isClassified = builder.classify();
        }
        timer.ifPresent(t -> t.stop());
        if (!isClassified) {
            return;
        }
        this._state.add(ReasoningState.CLASSIFY);
        this._estimate.computKBCosts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void realize() {
        boolean isRealized;
        TaxonomyBuilder builder;
        if (this.isRealized()) {
            return;
        }
        this.classify();
        if (!this.isClassified()) {
            return;
        }
        Optional<Timer> timer = this._timers.startTimer("realize");
        TaxonomyBuilder taxonomyBuilder = builder = this.getTaxonomyBuilder();
        synchronized (taxonomyBuilder) {
            isRealized = builder.realize();
        }
        timer.ifPresent(t -> t.stop());
        if (!isRealized) {
            return;
        }
        this._state.add(ReasoningState.REALIZE);
        this._estimate.computKBCosts();
    }

    @Override
    public Set<ATermAppl> currentIndividuals() {
        return this._individuals;
    }

    @Override
    public Set<ATermAppl> getIndividuals() {
        return Collections.unmodifiableSet(this._individuals);
    }

    @Override
    public int getIndividualsCount() {
        return this._individuals.size();
    }

    @Override
    public Stream<ATermAppl> individuals() {
        return this._individuals.stream();
    }

    @Override
    public boolean isSatisfiable(ATermAppl c) {
        Bool equivToBottom;
        if (null == c) {
            return false;
        }
        this.ensureConsistency();
        if (!this.isClass((ATerm)c)) {
            Base.handleUndefinedEntity(c + " is not a known class!");
            return false;
        }
        ATermAppl normalClass = ATermUtils.normalize(c);
        if (this.isClassified() && !this.doExplanation() && (equivToBottom = this.getTaxonomyBuilder().getTaxonomy().isEquivalent(ATermUtils.BOTTOM, normalClass)).isKnown()) {
            return equivToBottom.isFalse();
        }
        return this._abox.isSatisfiable(normalClass);
    }

    @Override
    public boolean hasInstance(ATerm d) {
        if (null == d) {
            return false;
        }
        if (!this.isClass(d)) {
            Base.handleUndefinedEntity(d + " is not a class!");
            return false;
        }
        this.ensureConsistency();
        ATermAppl c = ATermUtils.normalize((ATermAppl)d);
        ArrayList<ATermAppl> unknowns = new ArrayList<ATermAppl>();
        IndividualIterator i = new IndividualIterator(this._abox);
        while (i.hasNext()) {
            ATermAppl x = ((Individual)i.next()).getName();
            Bool knownType = this._abox.isKnownType(x, c);
            if (knownType.isTrue()) {
                return true;
            }
            if (!knownType.isUnknown()) continue;
            unknowns.add(x);
        }
        boolean hasInstance = !unknowns.isEmpty() && this._abox.existType(unknowns, c);
        return hasInstance;
    }

    @Override
    public boolean isSameAs(ATermAppl t1, ATermAppl t2) {
        if (null == t1 || null == t2) {
            return false;
        }
        this.ensureConsistency();
        if (!this.isIndividual((ATerm)t1)) {
            Base.handleUndefinedEntity(t1 + " is not an individual!");
            return false;
        }
        if (!this.isIndividual((ATerm)t2)) {
            Base.handleUndefinedEntity(t2 + " is not an individual!");
            return false;
        }
        if (t1.equals(t2)) {
            return true;
        }
        HashSet<ATermAppl> knowns = new HashSet<ATermAppl>();
        HashSet<ATermAppl> unknowns = new HashSet<ATermAppl>();
        Individual ind = this._abox.getIndividual((ATerm)t1);
        if (ind.isMerged() && !ind.getMergeDependency(true).isIndependent()) {
            this._abox.getSames(ind.getSame(), unknowns, unknowns);
        } else {
            this._abox.getSames(ind.getSame(), knowns, unknowns);
        }
        if (knowns.contains(t2)) {
            if (!this.doExplanation()) {
                return true;
            }
        } else if (!unknowns.contains(t2)) {
            return false;
        }
        return this._abox.isSameAs(t1, t2);
    }

    @Override
    public boolean isDifferentFrom(ATermAppl t1, ATermAppl t2) {
        if (null == t1 || null == t2) {
            return false;
        }
        Individual ind1 = this._abox.getIndividual((ATerm)t1);
        Individual ind2 = this._abox.getIndividual((ATerm)t2);
        if (ind1 == null) {
            Base.handleUndefinedEntity(t1 + " is not an individual!");
            return false;
        }
        if (ind2 == null) {
            Base.handleUndefinedEntity(t2 + " is not an individual!");
            return false;
        }
        if (ind1.isDifferent(ind2) && !this.doExplanation()) {
            return true;
        }
        ATermAppl c = ATermUtils.makeNot((ATerm)ATermUtils.makeValue((ATerm)t2));
        return this.isType(t1, c);
    }

    @Override
    public Set<ATermAppl> getDifferents(ATermAppl name) {
        if (null == name) {
            return Collections.emptySet();
        }
        this.ensureConsistency();
        Individual ind = this._abox.getIndividual((ATerm)name);
        if (ind == null) {
            Base.handleUndefinedEntity(name + " is not an individual!");
            return Collections.emptySet();
        }
        boolean isIndependent = true;
        if (ind.isMerged()) {
            isIndependent = ind.getMergeDependency(true).isIndependent();
            ind = ind.getSame();
        }
        ATermAppl c = ATermUtils.makeNot((ATerm)ATermUtils.makeValue((ATerm)name));
        HashSet<ATermAppl> differents = new HashSet<ATermAppl>();
        for (ATermAppl x : this._individuals) {
            Bool isType = this._abox.isKnownType(x, c);
            if (isIndependent && isType.isKnown()) {
                if (!isType.isTrue()) continue;
                differents.add(x);
                continue;
            }
            if (!this.isType(x, c)) continue;
            differents.add(x);
        }
        return differents;
    }

    @Override
    public boolean hasPropertyValue(ATermAppl s, ATermAppl p, ATermAppl o) {
        if (null == s || null == p) {
            return false;
        }
        this.ensureConsistency();
        if (!this.isIndividual((ATerm)s)) {
            Base.handleUndefinedEntity(s + " is not an individual!");
            return false;
        }
        if (!this.isProperty((ATerm)p)) {
            Base.handleUndefinedEntity(p + " is not a known property!");
            return false;
        }
        if (o != null && (this.isDatatypeProperty((ATerm)p) ? !ATermUtils.isLiteral(o) : !this.isIndividual((ATerm)o))) {
            return false;
        }
        return this._abox.hasPropertyValue(s, p, o);
    }

    @Override
    public Bool hasKnownPropertyValue(ATermAppl s, ATermAppl p, ATermAppl o) {
        if (null == s || null == p || null == o) {
            return Bool.FALSE;
        }
        this.ensureConsistency();
        return this._abox.hasObviousPropertyValue(s, p, o);
    }

    public Set<Set<ATermAppl>> getDisjoints(ATermAppl c) {
        if (null == c) {
            return Collections.emptySet();
        }
        if (this.isClass((ATerm)c)) {
            return this.getDisjointClasses(c);
        }
        if (this.isProperty((ATerm)c)) {
            return this.getDisjointProperties(c);
        }
        Base.handleUndefinedEntity(c + " is not a property nor a class!");
        return Collections.emptySet();
    }

    @Override
    public Set<Set<ATermAppl>> getDisjointProperties(ATermAppl p) {
        if (null == p) {
            return Collections.emptySet();
        }
        return this.getDisjointProperties(p, false);
    }

    public Set<Set<ATermAppl>> getDisjointProperties(ATermAppl p, boolean direct) {
        if (null == p) {
            return Collections.emptySet();
        }
        if (!this.isProperty((ATerm)p)) {
            Base.handleUndefinedEntity(p + " is not a property!");
            return Collections.emptySet();
        }
        Role role = this._rbox.getRole((ATerm)p);
        if (!role.isObjectRole() && !role.isDatatypeRole()) {
            return Collections.emptySet();
        }
        HashSet<Set<ATermAppl>> disjoints = new HashSet<Set<ATermAppl>>();
        TaxonomyNode node = this.getRoleTaxonomy(role.isObjectRole()).getTop();
        HashSet<TaxonomyNode<ATermAppl>> marked = new HashSet<TaxonomyNode<ATermAppl>>();
        ArrayList visit = new ArrayList();
        visit.add(node);
        for (int i = 0; i < visit.size(); ++i) {
            node = (TaxonomyNode)visit.get(i);
            if (node.isHidden() || node.getEquivalents().isEmpty() || marked.contains(node)) continue;
            ATermAppl r = (ATermAppl)node.getName();
            if (this.isDisjointProperty(p, r)) {
                Set eqs = this.getAllEquivalentProperties(r);
                if (!eqs.isEmpty()) {
                    disjoints.add(eqs);
                }
                if (direct) {
                    this.mark(node, marked);
                    continue;
                }
                disjoints.addAll(this.getSubProperties(r));
                continue;
            }
            visit.addAll(node.getSubs());
        }
        return disjoints;
    }

    private void mark(TaxonomyNode<ATermAppl> node, Set<TaxonomyNode<ATermAppl>> marked) {
        marked.add(node);
        for (TaxonomyNode<ATermAppl> next : node.getSubs()) {
            this.mark(next, marked);
        }
    }

    @Override
    public Set<ATermAppl> getComplements(ATermAppl c) {
        if (null == c) {
            return Collections.emptySet();
        }
        if (!this.isClass((ATerm)c)) {
            Base.handleUndefinedEntity(c + " is not a class!");
            return Collections.emptySet();
        }
        ATermAppl notC = ATermUtils.normalize(ATermUtils.makeNot((ATerm)c));
        Set complements = this.getAllEquivalentClasses(notC);
        if (notC.equals(ATermUtils.BOTTOM)) {
            complements.add(ATermUtils.BOTTOM);
        }
        return complements;
    }

    @Override
    public Set<ATermAppl> getSames(ATermAppl name) {
        if (null == name) {
            return Collections.emptySet();
        }
        Set<ATermAppl> sames = this.getAllSames(name);
        sames.remove(name);
        return sames;
    }

    public void printClassTree(PrintWriter out) {
        if (null == out) {
            return;
        }
        this.classify();
        new ClassTreePrinter().print(this.getTaxonomyBuilder().getTaxonomy(), out);
    }

    @Deprecated
    public void setDoDependencyAxioms(boolean doDepAxioms) {
        _logger.finer(() -> "Setting DoDependencyAxioms = " + doDepAxioms);
    }

    @Deprecated
    public boolean getDoDependencyAxioms() {
        return false;
    }

    @Override
    public CompletionStrategy chooseStrategy(ABox abox) {
        if (null == abox) {
            return null;
        }
        return this.chooseStrategy(abox, this.getExpressivity());
    }

    @Override
    public CompletionStrategy chooseStrategy(ABox abox, Expressivity expressivity) {
        boolean fullDatatypeReasoning;
        boolean conceptSatisfiability;
        if (null == abox || null == expressivity) {
            return null;
        }
        boolean bl = conceptSatisfiability = abox.size() == 1 && new IndividualIterator(abox).next().isConceptRoot();
        if (this.getRules().size() > 0 && (expressivity.hasNominal() || !conceptSatisfiability)) {
            return new ContinuousRulesStrategy(abox);
        }
        boolean bl2 = fullDatatypeReasoning = OpenlletOptions.USE_FULL_DATATYPE_REASONING && (expressivity.hasCardinalityD() || expressivity.hasKeys());
        if (!fullDatatypeReasoning && conceptSatisfiability && !expressivity.hasNominal()) {
            return new EmptySRIQStrategy(abox);
        }
        return new SROIQStrategy(abox);
    }

    @Override
    public void setTimeout(long timeout) {
        _logger.info(() -> "Timeout @ " + timeout + "ms");
        this._timers._mainTimer.setTimeout(timeout);
    }

    @Override
    public Taxonomy<ATermAppl> getTaxonomy() {
        this.classify();
        return this.getTaxonomyBuilder().getTaxonomy();
    }

    @Override
    public void setTaxonomyBuilderProgressMonitor(ProgressMonitor progressMonitor) {
        if (null == progressMonitor) {
            return;
        }
        this._builderProgressMonitor = progressMonitor;
        if (this._builder.isPresent()) {
            this.getTaxonomyBuilder().setProgressMonitor(progressMonitor);
        }
    }

    @Override
    public SizeEstimate getSizeEstimate() {
        return this._estimate;
    }

    @Override
    public boolean addRule(Rule rule) {
        if (null == rule) {
            return false;
        }
        this._changes.add(KnowledgeBase.ChangeType.ABOX_ADD);
        this._rules.put(rule, this.normalize(rule));
        _logger.finer(() -> "rule " + rule);
        return true;
    }

    private Rule normalize(Rule rule) {
        if (!UsableRuleFilter.isUsable(rule)) {
            return null;
        }
        List head = rule.getHead().stream().map(atom -> {
            ATermAppl normCls;
            ClassAtom ca;
            ATermAppl rawCls;
            if (atom instanceof ClassAtom && (rawCls = (ATermAppl)(ca = (ClassAtom)atom).getPredicate()) != (normCls = ATermUtils.normalize(rawCls))) {
                return new ClassAtom(normCls, (AtomIObject)ca.getArgument());
            }
            return atom;
        }).collect(Collectors.toList());
        HashMap types = new HashMap();
        for (RuleAtom ruleAtom : rule.getBody()) {
            Set<ATermAppl> ranges;
            AtomIObject obj;
            Set<ATermAppl> domains;
            if (!(ruleAtom instanceof IndividualPropertyAtom)) continue;
            IndividualPropertyAtom individualPropertyAtom = (IndividualPropertyAtom)ruleAtom;
            ATermAppl prop = (ATermAppl)individualPropertyAtom.getPredicate();
            AtomIObject subj = (AtomIObject)individualPropertyAtom.getArgument1();
            if (subj instanceof AtomIVariable && (domains = this.getRole((ATerm)prop).getDomains()) != null) {
                MultiMapUtils.addAll(types, subj, domains);
            }
            if (!((obj = (AtomIObject)individualPropertyAtom.getArgument2()) instanceof AtomIVariable) || (ranges = this.getRole((ATerm)prop).getRanges()) == null) continue;
            MultiMapUtils.addAll(types, obj, ranges);
        }
        ArrayList<RuleAtom> body = new ArrayList<RuleAtom>(rule.getBody().size());
        for (RuleAtom ruleAtom : rule.getBody()) {
            if (ruleAtom instanceof ClassAtom) {
                ATermAppl rawCls;
                ATermAppl normCls;
                ClassAtom ca = (ClassAtom)ruleAtom;
                AtomIObject arg = (AtomIObject)ca.getArgument();
                if (MultiMapUtils.contains(types, arg, normCls = ATermUtils.normalize(rawCls = (ATermAppl)ca.getPredicate()))) continue;
                body.add(rawCls == normCls ? ruleAtom : new ClassAtom(normCls, arg));
                continue;
            }
            body.add(ruleAtom);
        }
        return new Rule(rule.getName(), head, body);
    }

    @Override
    public Set<Rule> getRules() {
        return this._rules.keySet();
    }

    @Override
    public Map<Rule, Rule> getNormalizedRules() {
        return this._rules;
    }

    protected boolean canUseIncConsistency() {
        Expressivity expressivity = this._expChecker.getExpressivity();
        if (expressivity == null) {
            return false;
        }
        return !(expressivity.hasNominal() && expressivity.hasInverse() || !this.getRules().isEmpty() || this.isTBoxChanged() || this.isRBoxChanged() || !this._abox.isComplete() || !OpenlletOptions.USE_INCREMENTAL_CONSISTENCY || this._changes.contains((Object)KnowledgeBase.ChangeType.ABOX_DEL) && !OpenlletOptions.USE_INCREMENTAL_DELETION);
    }

    public void ensureIncConsistency(boolean aboxDeletion) {
        if (this.canUseIncConsistency()) {
            return;
        }
        Expressivity expressivity = this._expChecker.getExpressivity();
        String msg = "ABox " + (aboxDeletion ? "deletion" : "addition") + " failed because ";
        msg = expressivity == null ? msg + "an initial consistency check has not been performed on this KB" : (expressivity.hasNominal() ? msg + "KB has nominals" : (expressivity.hasInverse() ? msg + "KB has inverse properties" : (this.isTBoxChanged() ? msg + "TBox changed" : (this.isRBoxChanged() ? msg + "RBox changed" : (OpenlletOptions.USE_INCREMENTAL_CONSISTENCY ? msg + "configuration option USE_INCREMENTAL_CONSISTENCY is enabled" : (aboxDeletion ? msg + "configuration option USE_INCREMENTAL_DELETION is not enabled" : msg + "of an unknown reason"))))));
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public DependencyIndex getDependencyIndex() {
        return this._dependencyIndex;
    }

    @Override
    public Set<ATermAppl> getSyntacticAssertions() {
        return this._syntacticAssertions;
    }

    public Set<ATermAppl> getABoxAssertions(AssertionType assertionType) {
        if (null == assertionType) {
            return Collections.emptySet();
        }
        Set assertions = (Set)this._aboxAssertions.get((Object)assertionType);
        if (assertions == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(assertions);
    }

    @Override
    public Set<ATermAppl> getDeletedAssertions() {
        return this._deletedAssertions;
    }

    public boolean isExplainOnlyInconsistency() {
        return this._explainOnlyInconsistency;
    }

    public void setExplainOnlyInconsistency(boolean explainOnlyInconsistency) {
        this._explainOnlyInconsistency = explainOnlyInconsistency;
    }

    static {
        ATermUtils.getFactory();
    }

    public static enum AssertionType {
        TYPE,
        OBJ_ROLE,
        DATA_ROLE;

    }

    protected static enum ReasoningState {
        CONSISTENCY,
        CLASSIFY,
        REALIZE;

    }
}

