/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.boxes.abox;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.core.DependencySet;
import openllet.core.OpenlletOptions;
import openllet.core.boxes.abox.ABox;
import openllet.core.boxes.abox.ABoxImpl;
import openllet.core.boxes.abox.Clash;
import openllet.core.boxes.abox.Node;
import openllet.core.boxes.abox.NodeMerge;
import openllet.core.datatypes.DatatypeReasoner;
import openllet.core.datatypes.OWLRealUtils;
import openllet.core.datatypes.exceptions.DatatypeReasonerException;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.datatypes.exceptions.UnrecognizedDatatypeException;
import openllet.core.exceptions.InternalReasonerException;
import openllet.core.utils.ATermUtils;

public class Literal
extends Node {
    private final ATermAppl _atermValue;
    private final Object _value;
    private final boolean _hasValue;
    private volatile NodeMerge _merge;
    private volatile boolean _clashed = false;

    public Literal(ATermAppl name, ATermAppl term, ABox abox, DependencySet ds) {
        super(name, abox);
        if (term != null) {
            boolean bl = this._hasValue = !term.getArgument(2).equals((Object)ATermUtils.NO_DATATYPE);
            if (this._hasValue) {
                Object value = null;
                try {
                    value = abox.getDatatypeReasoner().getValue(term);
                }
                catch (InvalidLiteralException e) {
                    String msg = String.format("Attempt to create literal from invalid literal (%s): %s", term, e.getMessage());
                    if (OpenlletOptions.INVALID_LITERAL_AS_INCONSISTENCY) {
                        _logger.fine(msg);
                    }
                    _logger.severe(msg);
                    throw new InternalReasonerException(msg, e);
                }
                catch (UnrecognizedDatatypeException e) {
                    String msg = String.format("Attempt to create literal from with unrecognized datatype (%s): %s", term, e.getMessage());
                    _logger.severe(msg);
                    throw new InternalReasonerException(msg, e);
                }
                this._value = value;
                if (this._value == null) {
                    this._depends.put(name, ds);
                }
            } else {
                this._value = null;
            }
            this._atermValue = ATermUtils.makeValue((ATerm)term);
        } else {
            this._value = null;
            this._atermValue = null;
            this._hasValue = false;
        }
    }

    public Literal(Literal literal, ABoxImpl abox) {
        super(literal, abox);
        this._atermValue = literal._atermValue;
        this._value = literal._value;
        this._hasValue = literal._hasValue;
    }

    @Override
    public DependencySet getNodeDepends() {
        return this.getDepends((ATerm)ATermUtils.TOP_LIT);
    }

    @Override
    public Node copyTo(ABoxImpl abox) {
        return new Literal(this, abox);
    }

    @Override
    public final boolean isLeaf() {
        return true;
    }

    @Override
    public int getNominalLevel() {
        return this.isNominal() ? 0 : Integer.MAX_VALUE;
    }

    @Override
    public boolean isNominal() {
        return this._value != null;
    }

    @Override
    public boolean isBlockable() {
        return this._value == null;
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    @Override
    public boolean isIndividual() {
        return false;
    }

    @Override
    public boolean isDifferent(Node node) {
        if (super.isDifferent(node)) {
            return true;
        }
        Literal literal = (Literal)node;
        if (this._hasValue && literal._hasValue) {
            Class<?> thisvalueClass = this._value.getClass();
            Class<?> thatValueClass = literal._value.getClass();
            if (Literal.isAcceptableNumber(thisvalueClass) && Literal.isAcceptableNumber(thatValueClass)) {
                return OWLRealUtils.compare((Number)this._value, (Number)literal._value) != 0;
            }
            return thisvalueClass.equals(thatValueClass) && !this._value.equals(literal._value);
        }
        return false;
    }

    private static boolean isAcceptableNumber(Class<? extends Object> cls) {
        return OWLRealUtils.acceptable(cls);
    }

    @Override
    public boolean hasType(ATerm typeParam) {
        ATermAppl a;
        ATerm type = typeParam;
        if (type instanceof ATermAppl && ATermUtils.isNominal(a = (ATermAppl)type)) {
            try {
                ATermAppl input = (ATermAppl)a.getArgument(0);
                ATermAppl canonical = this._abox.getDatatypeReasoner().getCanonicalRepresentation(input);
                if (!canonical.equals(input)) {
                    type = ATermUtils.makeValue((ATerm)canonical);
                }
            }
            catch (InvalidLiteralException e) {
                _logger.warning(String.format("hasType called with nominal using invalid literal ('%s'), returning false", e.getMessage()));
                return false;
            }
            catch (UnrecognizedDatatypeException e) {
                _logger.warning(String.format("hasType called with nominal using literal with unrecognized datatype ('%s'), returning false", e.getMessage()));
                return false;
            }
        }
        if (super.hasType(type)) {
            return true;
        }
        return this._hasValue && this._atermValue.equals(type);
    }

    @Override
    public DependencySet getDifferenceDependency(Node node) {
        DependencySet ds = null;
        if (this.isDifferent(node) && (ds = (DependencySet)this._differents.get(node)) == null) {
            ds = DependencySet.INDEPENDENT;
        }
        return ds;
    }

    @Override
    public void addType(ATermAppl c, DependencySet d) {
        ATermAppl arg;
        if (this.hasType((ATerm)c)) {
            return;
        }
        if (ATermUtils.isNot(c) && ATermUtils.isNominal(arg = (ATermAppl)c.getArgument(0))) {
            ATermAppl v = (ATermAppl)arg.getArgument(0);
            Literal other = this._abox.getLiteral((ATerm)v);
            if (other == null) {
                other = this._abox.addLiteral(v, d);
            }
            super.setDifferent(other, d);
            return;
        }
        super.addType(c, d);
        this.checkClash();
    }

    public void addAllTypes(Map<ATermAppl, DependencySet> types, DependencySet ds) {
        for (Map.Entry<ATermAppl, DependencySet> entry : types.entrySet()) {
            ATermAppl c = entry.getKey();
            if (this.hasType((ATerm)c)) continue;
            DependencySet depends = entry.getValue();
            super.addType(c, depends.union(ds, this._abox.doExplanation()));
        }
        this.checkClash();
    }

    @Override
    public boolean hasSuccessor(Node x) {
        return false;
    }

    @Override
    public final Literal getSame() {
        return (Literal)super.getSame();
    }

    @Override
    public ATermAppl getTerm() {
        return this._hasValue ? (ATermAppl)this._atermValue.getArgument(0) : null;
    }

    public String getLang() {
        return this._hasValue ? ((ATermAppl)((ATermAppl)this._atermValue.getArgument(0)).getArgument(1)).getName() : "";
    }

    public String getLexicalValue() {
        if (this._hasValue) {
            return this._value.toString();
        }
        return null;
    }

    public void reportClash(Clash clash) {
        this._clashed = true;
        this._abox.setClash(clash);
    }

    private void checkClash() {
        this._clashed = false;
        if (this._hasValue && this._value == null) {
            this.reportClash(Clash.invalidLiteral(this, this.getDepends((ATerm)this._name), this.getTerm()));
            return;
        }
        if (this.hasType((ATerm)ATermUtils.BOTTOM_LIT)) {
            this.reportClash(Clash.emptyDatatype(this, this.getDepends((ATerm)ATermUtils.BOTTOM_LIT)));
            if (this._abox.doExplanation()) {
                System.out.println("1) Literal clash dependency = " + this._abox.getClash());
            }
            return;
        }
        Set<ATermAppl> types = this.getTypes();
        DatatypeReasoner dtReasoner = this._abox.getDatatypeReasoner();
        try {
            if (this._hasValue) {
                if (!dtReasoner.isSatisfiable(types, this._value)) {
                    ArrayList<ATermAppl> primitives = new ArrayList<ATermAppl>();
                    for (ATermAppl t : types) {
                        if (ATermUtils.TOP_LIT.equals(t)) continue;
                        primitives.add(t);
                    }
                    ATermAppl[] dt = primitives.toArray(new ATermAppl[primitives.size() - 1]);
                    DependencySet ds = DependencySet.EMPTY;
                    for (ATermAppl element : dt) {
                        ATermAppl dtName;
                        ATermAppl definition;
                        ds = ds.union(this.getDepends((ATerm)element), this._abox.doExplanation());
                        if (!this._abox.doExplanation() || (definition = dtReasoner.getDefinition(dtName = ATermUtils.isNot(element) ? (ATermAppl)element.getArgument(0) : element)) == null) continue;
                        ds = ds.union(Collections.singleton(ATermUtils.makeDatatypeDefinition(dtName, definition)), true);
                    }
                    this.reportClash(Clash.valueDatatype(this, ds, (ATermAppl)this._atermValue.getArgument(0), dt[0]));
                }
            } else if (dtReasoner.isSatisfiable(types)) {
                if (!dtReasoner.containsAtLeast(2, types)) {
                    Object value = dtReasoner.valueIterator(types).next();
                    ATermAppl valueTerm = dtReasoner.getLiteral(value);
                    Literal valueLiteral = this._abox.getLiteral((ATerm)valueTerm);
                    if (valueLiteral == null) {
                        valueLiteral = this._abox.addLiteral(valueTerm);
                    }
                    DependencySet mergeDs = DependencySet.INDEPENDENT;
                    for (DependencySet ds : this._depends.values()) {
                        mergeDs = mergeDs.union(ds, this._abox.doExplanation());
                    }
                    this._merge = new NodeMerge(this, valueLiteral, mergeDs);
                }
            } else {
                ArrayList<ATermAppl> primitives = new ArrayList<ATermAppl>();
                for (ATermAppl t : types) {
                    if (ATermUtils.TOP_LIT.equals(t)) continue;
                    primitives.add(t);
                }
                ATermAppl[] dt = primitives.toArray(new ATermAppl[primitives.size() - 1]);
                DependencySet ds = DependencySet.EMPTY;
                for (ATermAppl element : dt) {
                    ATermAppl definition;
                    ds = ds.union(this.getDepends((ATerm)element), this._abox.doExplanation());
                    if (!this._abox.doExplanation() || (definition = dtReasoner.getDefinition(element)) == null) continue;
                    ds = ds.union(Collections.singleton(ATermUtils.makeDatatypeDefinition(element, definition)), true);
                }
                this.reportClash(Clash.emptyDatatype(this, ds, dt));
            }
        }
        catch (DatatypeReasonerException e) {
            String msg = "Unexcepted datatype reasoner exception: " + e.getMessage();
            _logger.severe(msg);
            throw new InternalReasonerException(msg, e);
        }
    }

    public Object getValue() {
        return this._value;
    }

    @Override
    public boolean restore(int branch) {
        Boolean restorePruned = this.restorePruned(branch);
        if (Boolean.FALSE.equals(restorePruned)) {
            return restorePruned;
        }
        boolean restored = Boolean.TRUE.equals(restorePruned);
        restored |= super.restore(branch);
        if (this._clashed) {
            this.checkClash();
        }
        return restored;
    }

    @Override
    public final void prune(DependencySet ds) {
        this._pruned = ds;
    }

    @Override
    public void unprune(int branch) {
        super.unprune(branch);
        this.checkClash();
    }

    public NodeMerge getMergeToConstant() {
        return this._merge;
    }

    public void clearMergeToConstant() {
        this._merge = null;
    }
}

