/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.boxes.tbox.impl;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import openllet.aterm.ATermAppl;
import openllet.core.boxes.tbox.impl.UnaryTBox;
import openllet.core.boxes.tbox.impl.Unfolding;
import openllet.core.utils.ATermUtils;
import openllet.core.utils.BinarySet;
import openllet.core.utils.CollectionUtils;
import openllet.core.utils.iterator.IteratorUtils;
import openllet.shared.tools.Log;

public class BinaryTBox {
    private static final Logger _logger = Log.getLogger(UnaryTBox.class);
    private final Map<BinarySet<ATermAppl>, Unfolding> _unfoldings = CollectionUtils.makeMap();
    private final Map<ATermAppl, List<Unfolding>> _conditionalUnfoldings = CollectionUtils.makeIdentityMap();

    public void add(BinarySet<ATermAppl> set, ATermAppl result, Set<ATermAppl> explanation) {
        _logger.fine(() -> "Add sub: (" + ATermUtils.toString((ATermAppl)set.first()) + ", " + ATermUtils.toString((ATermAppl)set.second()) + ") < " + ATermUtils.toString(result));
        ATermAppl normalizedResult = ATermUtils.normalize(result);
        this._unfoldings.put(set, Unfolding.create(normalizedResult, explanation));
        this.addUnfolding(set.first(), set.second(), normalizedResult, explanation);
        this.addUnfolding(set.second(), set.first(), normalizedResult, explanation);
    }

    private void addUnfolding(ATermAppl c, ATermAppl condition, ATermAppl result, Set<ATermAppl> explanation) {
        List<Unfolding> list = this._conditionalUnfoldings.get(c);
        if (list == null) {
            list = CollectionUtils.makeList();
            this._conditionalUnfoldings.put(c, list);
        }
        list.add(Unfolding.create(result, condition, explanation));
    }

    public Unfolding unfold(BinarySet<ATermAppl> set) {
        return this._unfoldings.get(set);
    }

    public Iterator<Unfolding> unfold(ATermAppl concept) {
        List<Unfolding> unfoldingList = this._conditionalUnfoldings.get(concept);
        return unfoldingList == null ? IteratorUtils.emptyIterator() : unfoldingList.iterator();
    }

    public boolean contains(ATermAppl concept) {
        return this._conditionalUnfoldings.containsKey(concept);
    }

    public void print(Appendable out) throws IOException {
        for (Map.Entry<BinarySet<ATermAppl>, Unfolding> e : this._unfoldings.entrySet()) {
            BinarySet<ATermAppl> set = e.getKey();
            out.append("(");
            out.append(ATermUtils.toString(set.first()));
            out.append(",");
            out.append(ATermUtils.toString(set.second()));
            out.append(") < ");
            out.append(e.getValue().toString());
            out.append("\n");
        }
    }
}

