/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes;

import java.util.ArrayList;
import java.util.Map;
import openllet.aterm.ATerm;
import openllet.aterm.ATermAppl;
import openllet.aterm.ATermList;
import openllet.core.output.ATermBaseVisitor;
import openllet.core.utils.ATermUtils;

public class NamedDataRangeExpander
extends ATermBaseVisitor {
    private Map<ATermAppl, ATermAppl> _map;
    private ATermAppl _ret;
    private boolean _change;

    public ATermAppl expand(ATermAppl input, Map<ATermAppl, ATermAppl> map) {
        if (map.isEmpty()) {
            return input;
        }
        this._map = map;
        try {
            this.visit(input);
        }
        catch (UnsupportedOperationException e) {
            throw new IllegalArgumentException(e);
        }
        return this._ret;
    }

    @Override
    public void visitAll(ATermAppl term) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitAnd(ATermAppl term) {
        boolean listChange = false;
        ArrayList<ATermAppl> args = new ArrayList<ATermAppl>();
        ATermList l = (ATermList)term.getArgument(0);
        while (!l.isEmpty()) {
            ATermAppl a = (ATermAppl)l.getFirst();
            this.visit(a);
            args.add(this._ret);
            if (this._change) {
                listChange = true;
            }
            l = l.getNext();
        }
        if (listChange) {
            this._change = true;
            this._ret = ATermUtils.makeAnd(ATermUtils.makeList(args));
        } else {
            this._change = false;
            this._ret = term;
        }
    }

    @Override
    public void visitCard(ATermAppl term) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitHasValue(ATermAppl term) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitInverse(ATermAppl p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitLiteral(ATermAppl term) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitMax(ATermAppl term) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitMin(ATermAppl term) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitNot(ATermAppl term) {
        ATermAppl a = (ATermAppl)term.getArgument(0);
        this.visit(a);
        this._ret = this._change ? ATermUtils.makeNot((ATerm)this._ret) : term;
    }

    @Override
    public void visitOneOf(ATermAppl term) {
        this._ret = term;
        this._change = false;
    }

    @Override
    public void visitOr(ATermAppl term) {
        boolean listChange = false;
        ArrayList<ATermAppl> args = new ArrayList<ATermAppl>();
        ATermList l = (ATermList)term.getArgument(0);
        while (!l.isEmpty()) {
            ATermAppl a = (ATermAppl)l.getFirst();
            this.visit(a);
            args.add(this._ret);
            if (this._change) {
                listChange = true;
            }
            l = l.getNext();
        }
        if (listChange) {
            this._change = true;
            this._ret = ATermUtils.makeOr(ATermUtils.makeList(args));
        } else {
            this._change = false;
            this._ret = term;
        }
    }

    @Override
    public void visitRestrictedDatatype(ATermAppl dt) {
        this._ret = dt;
        this._change = false;
    }

    @Override
    public void visitSelf(ATermAppl term) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitSome(ATermAppl term) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitTerm(ATermAppl term) {
        ATermAppl a = this._map.get(term);
        if (a == null) {
            this._ret = term;
            this._change = false;
        } else {
            this._ret = a;
            this._change = true;
        }
    }

    @Override
    public void visitValue(ATermAppl term) {
        this._ret = term;
        this._change = false;
    }
}

