/*
 * Decompiled with CFR 0.152.
 */
package openllet.core.datatypes;

import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import openllet.aterm.ATermAppl;
import openllet.core.datatypes.Datatype;
import openllet.core.datatypes.IEEEDoubleType;
import openllet.core.datatypes.RestrictedDatatype;
import openllet.core.datatypes.RestrictedFloatingPointDatatype;
import openllet.core.datatypes.exceptions.InvalidLiteralException;
import openllet.core.utils.ATermUtils;
import openllet.shared.tools.Log;

public class XSDDouble
implements Datatype<Double> {
    private static final XSDDouble instance = new XSDDouble();
    private static final Logger _logger = Log.getLogger(XSDDouble.class);
    private final RestrictedFloatingPointDatatype<Double> dataRange;
    private final int hashCode;
    private final ATermAppl name = ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#double");

    public static XSDDouble getInstance() {
        return instance;
    }

    private XSDDouble() {
        this.hashCode = this.name.hashCode();
        this.dataRange = new RestrictedFloatingPointDatatype<Double>(this, IEEEDoubleType.getInstance());
    }

    @Override
    public RestrictedDatatype<Double> asDataRange() {
        return this.dataRange;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(input)) {
            throw new IllegalArgumentException();
        }
        if (!input.getArgument(2).equals((Object)this.name)) {
            throw new IllegalArgumentException();
        }
        String lexicalForm = ATermUtils.getLiteralValue(input);
        try {
            Double f = DatatypeConverter.parseDouble((String)lexicalForm);
            String canonicalForm = DatatypeConverter.printDouble((double)f);
            if (canonicalForm.equals(lexicalForm)) {
                return input;
            }
            return ATermUtils.makeTypedLiteral(canonicalForm, this.name);
        }
        catch (NumberFormatException e) {
            _logger.severe(String.format("Number format exception (%s) cause while parsing double %s", e.getMessage(), lexicalForm));
            throw new InvalidLiteralException(this.name, lexicalForm);
        }
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        if (IEEEDoubleType.getInstance().isInstance(value)) {
            return ATermUtils.makeTypedLiteral(DatatypeConverter.printDouble((double)IEEEDoubleType.getInstance().cast(value)), this.name);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public ATermAppl getName() {
        return this.name;
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Double getValue(ATermAppl literal) throws InvalidLiteralException {
        if (!ATermUtils.isLiteral(literal)) {
            throw new IllegalArgumentException();
        }
        if (!literal.getArgument(2).equals((Object)this.name)) {
            throw new IllegalArgumentException();
        }
        String lexicalForm = ATermUtils.getLiteralValue(literal);
        try {
            return DatatypeConverter.parseDouble((String)lexicalForm);
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.name, lexicalForm, e);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

